/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.logwriters;

import com.enhancera.accesslog.HostAppService;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.AccessRecordFormatter;
import com.enhancera.accesslog.common.ao.upgrade.UpgradeService;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.database.DataLayer;
import com.enhancera.accesslog.common.logwriters.CompoundAccessLogWriter;
import com.enhancera.accesslog.common.logwriters.DatabaseAccessLogWriter;
import com.enhancera.accesslog.common.logwriters.FileAccessLogWriter;
import com.enhancera.accesslog.common.logwriters.LogWriterFormattingUtils;
import com.enhancera.accesslog.common.logwriters.ProxyAccessLogWriter;
import com.enhancera.accesslog.common.logwriters.SyslogAccessLogWriter;
import java.util.List;

public class AccessLogWriterImpl
extends ProxyAccessLogWriter {
    private UpgradeService upgradeService;

    public AccessLogWriterImpl(HostAppService hostAppService, ConfigService configService, DataLayer dataLayer, AccessRecordFormatter accessRecordFormatter, UpgradeService upgradeService, LogWriterFormattingUtils logWriterFormattingUtils) {
        super(new CompoundAccessLogWriter().add(new DatabaseAccessLogWriter(dataLayer)).add(new SyslogAccessLogWriter(hostAppService, configService, logWriterFormattingUtils)).add(new FileAccessLogWriter(configService, accessRecordFormatter)));
        this.upgradeService = upgradeService;
    }

    @Override
    public void write(List<AccessRecord> records) {
        if (this.upgradeService.isUpgradeCompleted()) {
            super.write(records);
        }
    }
}

