/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.util;

import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.MacroInstance;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.service.content.ChildContentService;
import com.atlassian.confluence.api.service.content.ContentMacroService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.internal.pages.PageManagerInternal;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.sal.api.component.ComponentLocator;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class ConfluenceContentUtils {
    public static final ImmutableList<ContentType> ABSTRACT_PAGE_CONTENT_TYPES = ImmutableList.of((Object)ContentType.PAGE, (Object)ContentType.BLOG_POST);
    private static final String POSTING_DAY_SEPARATOR = "-";
    public static final String COMMENT_LOCATION_INLINE = "inline";
    public static final String COMMENT_LOCATION_FOOTER = "footer";
    public static final String COMMENT_LOCATION_RESOLVED = "resolved";
    public static final ImmutableList<String> COMMENT_LOCATIONS = ImmutableList.of((Object)"inline", (Object)"footer", (Object)"resolved");
    public static final ImmutableSet<String> INLINE_COMMENT_LOCATIONS = ImmutableSet.of((Object)"inline");
    private final PageManager pageManager;
    private final AttachmentManager attachmentManager;
    private final CommentManager commentManager;
    private final ContentService contentService;
    private final ChildContentService childContentService;
    private final SpaceService spaceService;
    private final ContentMacroService contentMacroService;
    private final SpaceManager spaceManager;
    private final CQLSearchService cqlSearchService;

    public ConfluenceContentUtils(PageManager pageManager, AttachmentManager attachmentManager, CommentManager commentManager, ContentService contentService, ChildContentService childContentService, SpaceService spaceService, ContentMacroService contentMacroService, SpaceManager spaceManager, CQLSearchService cqlSearchService) {
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.commentManager = commentManager;
        this.contentService = contentService;
        this.childContentService = childContentService;
        this.spaceService = spaceService;
        this.contentMacroService = contentMacroService;
        this.spaceManager = spaceManager;
        this.cqlSearchService = cqlSearchService;
    }

    public List<Content> getDescendantCommentsOfContent(long pageId, int parentVersion, int start, int limit) {
        return this.getCommentsOfContent(pageId, parentVersion, Collections.emptySet(), Depth.ALL, start, limit);
    }

    public List<Content> getCommentsOfContent(long contentId, int parentVersion, Set<String> location, Depth depth, int start, int limit) {
        ChildContentService.ChildContentFinder finder = this.childContentService.findContent(ContentId.valueOf((String)String.valueOf(contentId)), Expansions.of((String[])new String[]{"history"}).toArray());
        finder = finder.withDepth(depth);
        finder = finder.withLocation(location);
        finder = finder.withParentVersion(parentVersion);
        return finder.fetchMany(ContentType.COMMENT, (PageRequest)new SimplePageRequest(start, limit)).getResults();
    }

    public List<Content> getContentOfSpace(String spaceKey, Depth depth, @Nullable ContentType contentType, int start, int limit) {
        SpaceService.SpaceContentFinder finder = this.spaceService.findContent(com.atlassian.confluence.api.model.content.Space.builder().key(spaceKey).build(), Expansions.of((String[])new String[]{"history"}).toArray());
        finder = finder.withDepth(depth);
        SimplePageRequest pageRequest = new SimplePageRequest(start, limit);
        return contentType != null ? finder.fetchMany(contentType, (PageRequest)pageRequest).getResults() : finder.fetchMappedByType((PageRequest)pageRequest).values().stream().flatMap(response -> response.getResults().stream()).collect(Collectors.toList());
    }

    public List<Content> getContent(@Nullable String type, @Nullable String spaceKey, @Nullable String title, List<String> statuses, @Nullable String postingDay, String start, String limit) {
        Optional<DateTime> blogPostPublishedDate = ConfluenceContentUtils.getBlogPostPublishedDate(postingDay, POSTING_DAY_SEPARATOR);
        LocalDate publishedDateLocalDate = blogPostPublishedDate.isPresent() ? LocalDate.fromDateFields((Date)new Date(blogPostPublishedDate.get().getMillis())) : null;
        return this.getContent(type != null ? ContentType.valueOf((String)type) : ContentType.PAGE, !Strings.isNullOrEmpty((String)spaceKey) ? com.atlassian.confluence.api.model.content.Space.builder().key(spaceKey).id(this.spaceManager.getSpace(spaceKey).getId()).build() : null, title, (Set<ContentStatus>)ConfluenceRecordsParserUtils.parseContentStatuses(statuses), publishedDateLocalDate, NumberUtils.toInt(start), NumberUtils.toInt(limit, 25));
    }

    public List<Content> getContent(@Nullable ContentType type, @Nullable com.atlassian.confluence.api.model.content.Space space, @Nullable String title, Set<ContentStatus> statuses, @Nullable LocalDate postingDate, int start, int limit) {
        List<Content> result = Collections.emptyList();
        if (!ABSTRACT_PAGE_CONTENT_TYPES.contains((Object)type)) {
            return result;
        }
        ContentService.ContentFinder finder = this.contentService.find(Expansions.of((String[])new String[]{"history", "container"}).toArray());
        finder = (ContentService.ContentFinder)finder.withType(new ContentType[]{type});
        if (space != null) {
            finder = (ContentService.ContentFinder)finder.withSpace(new com.atlassian.confluence.api.model.content.Space[]{space});
        }
        if (title != null) {
            finder = (ContentService.ContentFinder)finder.withTitle(title);
        }
        if (!CollectionUtils.isEmpty(statuses)) {
            finder = finder.withStatus(statuses);
        }
        if (ContentType.BLOG_POST.equals((Object)type) && postingDate != null) {
            finder = (ContentService.ContentFinder)finder.withCreatedDate(postingDate);
        }
        return finder.fetchMany(type, (PageRequest)new SimplePageRequest(start, limit)).getResults();
    }

    public Optional<ContentEntityObject> getContentById(long contentId, Set<ContentStatus> statuses, int version) {
        Optional<ContentEntityObject> result = Optional.empty();
        ContentEntityObject contentEntityObject = this.getContentByIdAndVersion((ContentEntityManager)this.pageManager, contentId, version).orElse(null);
        if (contentEntityObject == null) {
            contentEntityObject = this.getContentByIdAndVersion((ContentEntityManager)this.commentManager, contentId, version).orElse(null);
        }
        if (contentEntityObject != null && statuses.contains(contentEntityObject.getContentStatusObject())) {
            result = Optional.of(contentEntityObject);
        }
        return result;
    }

    public Optional<MacroInstance> getMacroBody(long contentId, int version, String macroId) {
        ContentMacroService.MacroInstanceFinder finder = this.contentMacroService.findInContent(ContentId.valueOf((String)String.valueOf(contentId)), Expansions.EMPTY.toArray());
        finder = finder.withContentVersion(version);
        finder = finder.withMacroId(macroId);
        return Optional.ofNullable(finder.fetchOneOrNull());
    }

    public Optional<ContentEntityObject> getContentById(long contentId) {
        ContentEntityObject result = this.getContentByIdAndVersion((ContentEntityManager)this.pageManager, contentId, 0).orElse(null);
        if (result == null) {
            result = this.getContentByIdAndVersion((ContentEntityManager)this.commentManager, contentId, 0).orElse(null);
        }
        return Optional.ofNullable(result);
    }

    public List<Page> getChildPages(long contentId, int parentVersion, int start, int limit) {
        List result = Collections.emptyList();
        AbstractPage abstractPage = this.getContentByIdAndVersion((ContentEntityManager)this.pageManager, contentId, parentVersion).orElse(null);
        if (abstractPage != null && ContentType.PAGE.getValue().equals(abstractPage.getType())) {
            PageManagerInternal pageManagerInternal = (PageManagerInternal)ComponentLocator.getComponent(PageManagerInternal.class);
            result = pageManagerInternal.getChildren((Page)abstractPage, LimitedRequestImpl.create((int)start, (int)limit, (int)limit), Depth.ROOT).getResults();
        }
        return result;
    }

    public List<Content> getContentFromCqlSearch(String cql, @Nullable String cqlContext, int start, int limit) {
        return this.cqlSearchService.searchContent(cql, !Strings.isNullOrEmpty((String)cqlContext) ? SearchContext.deserialize((String)RequestUtils.decode(cqlContext), (ObjectMapper)new ObjectMapper()) : SearchContext.EMPTY, (PageRequest)new SimplePageRequest(start, limit), Expansions.of((String[])new String[]{"history", "container"}).toArray()).getResults();
    }

    public Optional<AbstractPage> getAbstractPageById(@Nullable Long pageId) {
        AbstractPage abstractPage = null;
        if (pageId != null) {
            abstractPage = this.pageManager.getAbstractPage(pageId.longValue());
        }
        return Optional.ofNullable(abstractPage);
    }

    public Optional<AbstractPage> getAbstractPageBySpaceKeyAndTitle(@Nullable String spaceKey, @Nullable String title, @Nullable String postingDay, String postingDaySeparator) {
        Optional<BlogPost> blogPost;
        Page page = null;
        if (Strings.isNullOrEmpty((String)spaceKey) || Strings.isNullOrEmpty((String)title)) {
            return Optional.empty();
        }
        page = this.pageManager.getPage(spaceKey, title);
        if (page == null && (blogPost = this.getBlogPostBySpaceAndTitleAndPostingDay(spaceKey, title, postingDay, postingDaySeparator)).isPresent()) {
            page = (AbstractPage)blogPost.get();
        }
        return Optional.ofNullable(page);
    }

    public Optional<Space> getSpace(@Nullable String spaceKey) {
        return Optional.ofNullable(spaceKey != null ? this.spaceManager.getSpace(spaceKey) : null);
    }

    public Optional<Attachment> getAttachment(long attachmentId) {
        return Optional.ofNullable(this.attachmentManager.getAttachment(attachmentId));
    }

    public Optional<Comment> getComment(long commentId) {
        return Optional.ofNullable(this.commentManager.getComment(commentId));
    }

    public Optional<Attachment> getAttachment(long pageId, String attachmentFilename) {
        Optional<AbstractPage> page = this.getAbstractPageById(pageId);
        return Optional.ofNullable(page.isPresent() ? this.attachmentManager.getAttachment((ContentEntityObject)page.get(), attachmentFilename) : null);
    }

    public Optional<ContentEntityObject> getContentByIdAndVersion(long id, int version) {
        Optional<ContentEntityObject> abstractPage = this.getContentByIdAndVersion((ContentEntityManager)this.pageManager, id, version);
        return abstractPage.isPresent() ? abstractPage : this.getContentByIdAndVersion((ContentEntityManager)this.commentManager, id, version);
    }

    private Optional<ContentEntityObject> getContentByIdAndVersion(ContentEntityManager contentEntityManager, long contentId, int version) {
        ContentEntityObject contentEntityObject = contentEntityManager.getById(contentId);
        if (contentEntityObject != null && version != 0) {
            contentEntityObject = contentEntityManager.getOtherVersion(contentEntityObject, version);
        }
        return Optional.ofNullable(contentEntityObject);
    }

    public List<Content> getAttachmentComments(long contentId, int start, @Nullable Integer attachmentVersion) {
        return this.getInlineOrAttachmentCommentsOrCommentReplies(contentId, start, false, attachmentVersion);
    }

    public List<Content> getAttachmentCommentReplies(long contentId, int start) {
        return this.getInlineOrAttachmentCommentsOrCommentReplies(contentId, start, false, null);
    }

    private List<Content> getInlineOrAttachmentCommentsOrCommentReplies(long contentId, int start, boolean isInlineComment, Integer attachmentVersion) {
        ChildContentService.ChildContentFinder finder = this.childContentService.findContent(ContentId.valueOf((String)String.valueOf(contentId)), Expansions.of((String[])new String[]{"history"}).toArray());
        if (isInlineComment) {
            finder = finder.withLocation(INLINE_COMMENT_LOCATIONS);
        } else if (attachmentVersion != null) {
            finder = finder.withParentVersion(attachmentVersion.intValue());
        }
        return finder.fetchMany(ContentType.COMMENT, (PageRequest)new SimplePageRequest(start, 999)).getResults();
    }

    public List<Content> getCommentsOfContent(long contentId, int start, boolean isInlineComments) {
        return this.getInlineOrAttachmentCommentsOrCommentReplies(contentId, start, isInlineComments, null);
    }

    private Optional<BlogPost> getBlogPostBySpaceAndTitleAndPostingDay(String spaceKey, String title, String postingDay, String postingDaySeparator) {
        BlogPost result = null;
        Optional<DateTime> publishedDate = ConfluenceContentUtils.getBlogPostPublishedDate(postingDay, postingDaySeparator);
        if (publishedDate.isPresent()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(publishedDate.get().getMillis());
            result = this.pageManager.getBlogPost(spaceKey, title, calendar);
        }
        return Optional.ofNullable(result);
    }

    private static Optional<DateTime> getBlogPostPublishedDate(@Nullable String postingDay, String postingDaySeparator) {
        List postingDayValues;
        DateTime result = null;
        List list = postingDayValues = postingDay != null ? Arrays.stream(postingDay.split(postingDaySeparator)).map(Ints::tryParse).collect(Collectors.toList()) : null;
        if (postingDayValues != null && postingDayValues.size() == 3 && !postingDayValues.contains(null)) {
            result = new DateTime(((Integer)postingDayValues.get(0)).intValue(), ((Integer)postingDayValues.get(1)).intValue(), ((Integer)postingDayValues.get(2)).intValue(), 0, 0);
        }
        return Optional.ofNullable(result);
    }
}

