/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.util;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.util.FormattingUtils;
import com.enhancera.accesslog.confluence.ConfluenceContentType;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class ConfluenceApiContentRecordsParserUtils {
    private final PageManager pageManager;
    private final CommentManager commentManager;
    private final AttachmentManager attachmentManager;

    public ConfluenceApiContentRecordsParserUtils(PageManager pageManager, CommentManager commentManager, AttachmentManager attachmentManager) {
        this.pageManager = pageManager;
        this.commentManager = commentManager;
        this.attachmentManager = attachmentManager;
    }

    public static ImmutableList<AccessRecord> parseAbstractPagesAccessRecords(List<Content> abstractPagesContent, RequestData requestData) {
        return abstractPagesContent.stream().flatMap(pageContent -> ConfluenceApiContentRecordsParserUtils.parseAbstractPageAccessRecords(pageContent, requestData).stream()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    private static ImmutableList<AccessRecord> parseAbstractPageAccessRecords(@Nullable Content pageContent, RequestData requestData) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        if (pageContent != null) {
            String contentDisplayName = ConfluenceApiContentRecordsParserUtils.getAbstractPageContentDisplayName(pageContent);
            result = ConfluenceRecordsParserUtils.parseAccessRecords(requestData.getUserKey(), requestData.getIpAddress(), (com.enhancera.accesslog.common.ContentType)(ContentType.BLOG_POST.equals((Object)pageContent.getType()) ? ConfluenceContentType.BLOG_POST : ConfluenceContentType.PAGE), pageContent.getId().asLong(), contentDisplayName, Action.VIEW);
        }
        return result;
    }

    public static ImmutableList<AccessRecord> parseContentAccessRecords(List<Content> contents, RequestData requestData) {
        return contents.stream().flatMap(content -> ConfluenceApiContentRecordsParserUtils.parseContentAccessRecords(content, requestData).stream()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    private static ImmutableList<AccessRecord> parseContentAccessRecords(@Nullable Content content, RequestData requestData) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        if (content != null) {
            ContentType contentType = content.getType();
            if (ContentType.COMMENT.equals((Object)content.getType())) {
                result = ConfluenceApiContentRecordsParserUtils.parseCommentAccessRecords(ConfluenceApiContentRecordsParserUtils.getAbstractPageContentDisplayName((Content)content.getContainer()), content, requestData);
            } else if (ConfluenceContentUtils.ABSTRACT_PAGE_CONTENT_TYPES.contains((Object)contentType)) {
                result = ConfluenceApiContentRecordsParserUtils.parseAbstractPageAccessRecords(content, requestData);
            }
        }
        return result;
    }

    public ImmutableList<AccessRecord> parseCommentsAccessRecords(long parentContentId, List<Content> commentsContent, RequestData requestData) {
        Optional<String> pageTitle = this.getTitleByContentId(parentContentId);
        return commentsContent.stream().flatMap(commentContent -> ConfluenceApiContentRecordsParserUtils.parseCommentAccessRecords((String)RecordParserUtils.parseOptionalValue("title", pageTitle), commentContent, requestData).stream()).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    private Optional<String> getTitleByContentId(long contentId) {
        ContentEntityObject contentEntityObject = this.pageManager.getById(contentId);
        if (contentEntityObject == null && (contentEntityObject = this.commentManager.getById(contentId)) != null && ContentTypeEnum.COMMENT.equals((Object)contentEntityObject.getTypeEnum())) {
            return Optional.of(ConfluenceRecordsParserUtils.getAbstractPageContentDisplayName((SpaceContentEntityObject)((Comment)contentEntityObject).getContainer()));
        }
        if (contentEntityObject == null) {
            contentEntityObject = this.attachmentManager.getAttachment(contentId);
        }
        return Optional.ofNullable(contentEntityObject.getTitle());
    }

    public static ImmutableList<AccessRecord> parseCommentAccessRecords(String pageTitle, Content commentContent, RequestData requestData) {
        return ConfluenceRecordsParserUtils.parseAccessRecords(requestData.getUserKey(), requestData.getIpAddress(), (com.enhancera.accesslog.common.ContentType)ConfluenceContentType.COMMENT, commentContent.getId().asLong(), RecordParserUtils.createCommentDisplayName(pageTitle, commentContent.getHistory().getCreatedDate()), Action.VIEW);
    }

    @VisibleForTesting
    public static String getAbstractPageContentDisplayName(Content pageContent) {
        String contentDisplayName = pageContent.getTitle();
        if (contentDisplayName == null) {
            contentDisplayName = RecordParserUtils.createContentDisplayNameWithAuxiliaryParam(pageContent.getSpace().getKey(), FormattingUtils.formatTime(new DateTime((Object)pageContent.getHistory().getCreatedDate())));
        }
        return contentDisplayName;
    }

    public static void addUserToThreadLocal(@Nullable UserKey userKey) {
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        AuthenticatedUserThreadLocal.set((ConfluenceUser)userAccessor.getUserByKey(userKey));
    }
}

