/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.recordparser.UriMatchingNonHeadParser;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceWebRecordsParserUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;

public class WordDavPreviewRecordsParser
extends UriMatchingNonHeadParser {
    private static final String REGEX_ATTACHMENT_FILENAME = ".*\\.(docx?|xlsx?)";
    private static final String PARAM_FILENAME = "fileName";
    private final ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils;
    private final ConfluenceContentUtils contentUtils;

    public WordDavPreviewRecordsParser(ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils, ConfluenceContentUtils contentUtils) {
        super("/pages/worddav/preview.action");
        this.confluenceWebRecordsParserUtils = confluenceWebRecordsParserUtils;
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        ImmutableList<AccessRecord> result = ImmutableList.of();
        String filename = RecordParserUtils.parseOptionalValue(PARAM_FILENAME, requestData.getRequestParameterValue(PARAM_FILENAME));
        if (filename == null || !filename.matches(REGEX_ATTACHMENT_FILENAME)) {
            return result;
        }
        Long pageId = Longs.tryParse((String)RecordParserUtils.parseOptionalValue("pageId", requestData.getRequestParameterValue("pageId")));
        if (pageId != null) {
            result = this.confluenceWebRecordsParserUtils.parseViewAttachmentRecords(requestData.getUserKey(), requestData.getIpAddress(), this.contentUtils.getAttachment(pageId, filename).orElse(null));
        }
        return result;
    }
}

