/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.enhancera.accesslog.common.data.SortKey;
import com.enhancera.accesslog.common.data.SortOrder;
import com.enhancera.accesslog.common.data.SortParam;
import com.enhancera.accesslog.common.data.SortParams;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.tuckey.web.filters.urlrewrite.utils.URLEncoder;

public class RequestUtils {
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final String X_CLIENT_IP = "X-Client-IP";
    public static final String PARAM_SORT_PARAMS = "sortParams";
    public static final String ID_PARAM = "id";
    public static final String ATTACHMENT_FILENAME = "filename";
    public static final String OBJECT_ID_PARAM = "objectId";
    public static final String OBJECT_KEY_PARAM = "objectKey";
    public static final String ASSET_COMMENT_CREATE_DATE_PARAM = "created";
    public static final String ISSUE_KEY_JSON_PARAM = "key";
    public static final String OBJECT_SCHEMA_KEY_PARAM = "objectSchemaKey";
    public static final String CREATED_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final FormattingLogger log = FormattingLogger.getLogger(RequestUtils.class);
    private final LoginUriProvider loginUriProvider;

    public RequestUtils(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public void redirectToLoginPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(RequestUtils.getUri(request)).toASCIIString());
    }

    private static URI getUri(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder(request.getRequestURI());
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public static String encode(String text) {
        String result = text;
        try {
            result = URLEncoder.encodePathParam(text, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            log.error("text: %s can't be encoded", text);
        }
        return result;
    }

    public static String decode(String text) {
        String result = text;
        try {
            result = URLDecoder.decode(text, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            log.error("text: %s can't be decoded", text);
        }
        return result;
    }

    public static SortParams parseSortParams(List<String> sortParamsStrings) {
        SortParams sortParams;
        if (!CollectionUtils.isEmpty(sortParamsStrings)) {
            sortParams = new SortParams();
            for (String sortParamString : sortParamsStrings) {
                String[] splitParamString = sortParamString.split(" ");
                SortOrder order = SortOrder.valueOf(splitParamString[1]);
                sortParams.put(SortParam.create(SortKey.valueOf(splitParamString[0]), order));
            }
        } else {
            sortParams = new SortParams(SortParam.create(SortKey.TIME, SortOrder.DESC));
        }
        return sortParams;
    }

    public static Optional<String> parseUriParam(String regexp, String value, String groupName) {
        return RequestUtils.parseUriParam(regexp, value, groupName, uriParam -> uriParam);
    }

    public static Optional<Long> parseUriParamLong(String regexp, String value, String groupName) {
        return RequestUtils.parseUriParam(regexp, value, groupName, valueToConvert -> {
            long result = NumberUtils.toLong((String)valueToConvert);
            return result != 0L ? Long.valueOf(result) : null;
        });
    }

    private static <T> Optional<T> parseUriParam(String regexp, String value, String groupName, Function<String, T> typeConverter) {
        Matcher matcher = Pattern.compile(regexp).matcher(value);
        return Optional.ofNullable(typeConverter.apply(matcher.find() ? matcher.group(groupName) : null));
    }

    public static ImmutableListMultimap<String, String> createRequestHeadersMultimap(HttpServletRequest req) {
        ArrayListMultimap result = ArrayListMultimap.create();
        Enumeration headerNames = req.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                Enumeration headerValues = req.getHeaders(name);
                if (headerValues == null) continue;
                while (headerValues.hasMoreElements()) {
                    result.put((Object)name, headerValues.nextElement());
                }
            }
        }
        return ImmutableListMultimap.copyOf((Multimap)result);
    }

    public static ImmutableListMultimap<String, String> createRequestParametersMultimap(HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        ArrayListMultimap result = ArrayListMultimap.create();
        if (parameterMap != null) {
            for (Map.Entry entry : parameterMap.entrySet()) {
                if (entry == null) continue;
                for (String value : (String[])entry.getValue()) {
                    result.put(entry.getKey(), (Object)value);
                }
            }
        }
        return ImmutableListMultimap.copyOf((Multimap)result);
    }

    public static List<String> getMultimapValues(ListMultimap<String, String> valuesMap, String parameterName) {
        List<String> values = valuesMap.get((Object)parameterName);
        return values != null ? values : Collections.emptyList();
    }

    public static Optional<String> getMultimapValue(ListMultimap<String, String> valuesMap, String parameterName) {
        List<String> values = RequestUtils.getMultimapValues(valuesMap, parameterName);
        return !CollectionUtils.isEmpty(values) ? Optional.of(values.iterator().next()) : Optional.empty();
    }

    public static String extractIpAddress(@Nullable HttpServletRequest httpRequest) {
        String result = "-";
        if (httpRequest == null) {
            return result;
        }
        return RequestUtils.extractProxyIpAddress(httpRequest).orElse(httpRequest.getRemoteAddr());
    }

    private static Optional<String> extractProxyIpAddress(HttpServletRequest httpRequest) {
        Optional<String> result = RequestUtils.getClientIpHeaderValue(X_FORWARDED_FOR_HEADER, httpRequest);
        if (!result.isPresent()) {
            result = RequestUtils.getClientIpHeaderValue(X_CLIENT_IP, httpRequest);
        }
        return result;
    }

    private static Optional<String> getClientIpHeaderValue(String headerName, HttpServletRequest httpRequest) {
        Enumeration requestHeaders = httpRequest.getHeaders(headerName);
        if (requestHeaders != null) {
            while (requestHeaders.hasMoreElements()) {
                String headerValue = (String)requestHeaders.nextElement();
                if (StringUtils.isBlank((String)headerValue)) continue;
                return Optional.of(X_FORWARDED_FOR_HEADER.equals(headerName) && headerValue.contains(",") ? headerValue.split(",")[0].trim() : headerValue);
            }
        }
        return Optional.empty();
    }
}

