/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.recordparser;

import com.atlassian.sal.api.user.UserKey;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.RecordsParser;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

public abstract class UriMatchingParser
implements RecordsParser {
    private static final ImmutableSet<Integer> VALID_STATUSES = ImmutableSet.of((Object)200, (Object)302, (Object)304, (Object)201, (Object)204);
    private final String uriRegexp;
    protected UserKey userKey;

    public UriMatchingParser(String uriRegexp) {
        this.uriRegexp = uriRegexp;
    }

    @Override
    public ImmutableList<AccessRecord> parseRecords(RequestData requestData, ResponseData responseData) {
        if (VALID_STATUSES.contains((Object)responseData.getStatus()) && this.isRequestMethodAcceptable(requestData) && RequestUtils.decode(requestData.getUri()).matches(requestData.getContextPath().concat(this.uriRegexp))) {
            return this.parse(requestData, responseData);
        }
        return ImmutableList.of();
    }

    protected boolean isRequestMethodAcceptable(RequestData requestData) {
        return "GET".equals(requestData.getMethod());
    }

    protected abstract ImmutableList<AccessRecord> parse(RequestData var1, ResponseData var2);
}

