/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.rest;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.confluence.recordparser.rest.BulkRestUriMatchingParser;
import com.enhancera.accesslog.confluence.util.ConfluenceApiContentRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class GetContentRestViewRecordParser
extends BulkRestUriMatchingParser {
    private static final String PARAM_TYPE = "type";
    private final ConfluenceContentUtils contentUtils;

    public GetContentRestViewRecordParser(ConfluenceContentUtils contentUtils) {
        super("/rest/api/content/?");
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        ConfluenceApiContentRecordsParserUtils.addUserToThreadLocal(requestData.getUserKey());
        return this.parseRestGetContentRecords(requestData);
    }

    ImmutableList<AccessRecord> parseRestGetContentRecords(RequestData requestData) {
        String type = requestData.getRequestParameterValue(PARAM_TYPE).orElse(null);
        String spaceKey = RecordParserUtils.parseOptionalValue("spaceKey", requestData.getRequestParameterValue("spaceKey"));
        String title = RecordParserUtils.parseOptionalValue("title", requestData.getRequestParameterValue("title"));
        List<String> statuses = requestData.getRequestParameterValues("status");
        String postingDay = requestData.getRequestParameterValue("postingDay").orElse(null);
        String start = requestData.getRequestParameterValue("start").orElse(null);
        String limit = requestData.getRequestParameterValue("limit").orElse(null);
        return ConfluenceApiContentRecordsParserUtils.parseAbstractPagesAccessRecords(this.contentUtils.getContent(type, spaceKey, title, statuses, postingDay, start, limit), requestData);
    }
}

