/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser;

import com.atlassian.confluence.pages.AbstractPage;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.UriMatchingNonHeadParser;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;

public class ViewAttachmentSlideRecordParser
extends UriMatchingNonHeadParser {
    private final ConfluenceRecordsParserUtils recordsParserUtils;
    private final ConfluenceContentUtils contentUtils;

    public ViewAttachmentSlideRecordParser(ConfluenceRecordsParserUtils recordsParserUtils, ConfluenceContentUtils contentUtils) {
        super("/plugins/servlet/pptslide");
        this.recordsParserUtils = recordsParserUtils;
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        return this.parseAttachmentRecords(requestData);
    }

    ImmutableList<AccessRecord> parseAttachmentRecords(RequestData requestData) {
        Optional<String> attachmentFilenameOptional;
        ImmutableList<AccessRecord> result = ImmutableList.of();
        Optional<String> pageIdStr = requestData.getRequestParameterValue("pageId");
        Long pageId = pageIdStr.isPresent() ? Longs.tryParse((String)pageIdStr.get()) : null;
        Optional<Object> page = Optional.empty();
        if (pageId != null) {
            page = this.contentUtils.getAbstractPageById(pageId);
        }
        if (page.isPresent() && (attachmentFilenameOptional = requestData.getRequestParameterValue("attachment")).isPresent()) {
            Optional<String> slideOptional = requestData.getRequestParameterValue("slide");
            int version = NumberUtils.toInt(requestData.getRequestParameterValue("attachmentVer").orElse(null));
            String decodedFilename = RequestUtils.decode(attachmentFilenameOptional.get());
            int slide = 0;
            if (slideOptional.isPresent()) {
                slide = NumberUtils.toInt(slideOptional.get());
            }
            result = ViewAttachmentSlideRecordParser.isAttachmentViewFromPreview(requestData) ? this.recordsParserUtils.parseViewAttachmentRecords(requestData.getUserKey(), requestData.getIpAddress(), (AbstractPage)page.get(), decodedFilename, version) : this.recordsParserUtils.parseDownloadAttachmentSlideRecords(requestData.getUserKey(), requestData.getIpAddress(), (AbstractPage)page.get(), decodedFilename, version, slide);
        }
        return result;
    }

    private static boolean isAttachmentViewFromPreview(RequestData requestData) {
        Optional<String> readyParamenterValue = requestData.getRequestParameterValue("ready");
        boolean isReady = false;
        if (readyParamenterValue.isPresent()) {
            isReady = Boolean.parseBoolean(readyParamenterValue.get());
        }
        return isReady && ViewAttachmentSlideRecordParser.isReferedFromPreview(requestData);
    }

    private static boolean isReferedFromPreview(RequestData requestData) {
        Optional<String> refererHeader = requestData.getRequestHeaderValue("referer");
        boolean isReferedFromPreview = false;
        if (refererHeader.isPresent()) {
            isReferedFromPreview = refererHeader.get().matches(".*/pages/worddav/preview.action.*");
        }
        return isReferedFromPreview;
    }
}

