/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import javax.annotation.Nullable;

public class UserUtils {
    private final UserManager userManager;

    public UserUtils(UserManager userManager) {
        this.userManager = userManager;
    }

    @Nullable
    public UserKey getRemoteUserKey() {
        return this.userManager.getRemoteUserKey();
    }

    @Nullable
    public UserProfile getUserProfile(UserKey userKey) {
        return this.userManager.getUserProfile(userKey);
    }

    public boolean isAdmin() {
        return this.userManager.isAdmin(this.userManager.getRemoteUserKey());
    }

    public String getUserNameOrUnknown(@Nullable String userKey) {
        return userKey != null ? this.getUserNameOrUnknown(new UserKey(userKey)) : "<unknown>";
    }

    public String getUserNameOrUnknown(@Nullable UserKey userKey) {
        if (userKey == null) {
            return "<unknown>";
        }
        String userName = this.getUserName(userKey);
        return userName != null ? userName : "<unknown>";
    }

    @Nullable
    public String getUserName(@Nullable UserKey userKey) {
        UserProfile userProfile = userKey != null ? this.userManager.getUserProfile(userKey) : null;
        return userProfile != null ? userProfile.getUsername() : null;
    }

    @Nullable
    public String getUserKeyValueByName(@Nullable String username) {
        UserProfile userProfile = username != null ? this.userManager.getUserProfile(username) : null;
        UserKey userKey = userProfile != null ? userProfile.getUserKey() : null;
        return userKey != null ? userKey.getStringValue() : null;
    }

    @Nullable
    public static String getUserKeyStr(@Nullable UserKey userKey) {
        return userKey != null ? userKey.getStringValue() : null;
    }
}

