/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.google.common.base.Throwables;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;

public class AccessLogClusterLockService {
    public static final long DEFAULT_TIMEOUT = 300L;
    public static final long LONG_TIMEOUT = 3600L;
    private static final String UPGRADE_TASK_LOCK = "com.enhancera.accesslog.locks.UpgradeTaskLock";
    private final ClusterLockService clusterLockService;

    public AccessLogClusterLockService(ClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
    }

    public <T> T executeWithLock(String lockName, Supplier<T> supplier, long timeout) throws TimeoutException {
        try {
            ClusterLock lock = this.clusterLockService.getLockForName(lockName);
            if (lock.tryLock(timeout, TimeUnit.SECONDS)) {
                return this.tryFinallyUnlock(supplier, (Lock)lock);
            }
            throw new TimeoutException("Timeout acquiring " + lockName + " lock");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public <T> T executeWithUpgradeLock(Supplier<T> supplier) throws TimeoutException {
        return this.executeWithLock(UPGRADE_TASK_LOCK, supplier, 300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T tryFinallyUnlock(Supplier<T> supplier, Lock lock) {
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
            Thread.yield();
        }
    }
}

