/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.config.ConfigUpdateService;
import com.enhancera.accesslog.common.util.FileUtils;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.UserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/config")
public class ConfigRestResource {
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfigRestResource.class);
    private final UserUtils userUtils;
    private final FileUtils fileUtils;
    private final ConfigService configService;
    private final ConfigUpdateService configUpdateService;
    private final Executor executor = Executors.newSingleThreadExecutor();
    private final TransactionTemplate transactionTemplate;

    public ConfigRestResource(UserUtils userUtils, FileUtils fileUtils, ConfigService configService, ConfigUpdateService configUpdateService, TransactionTemplate transactionTemplate) {
        this.userUtils = userUtils;
        this.fileUtils = fileUtils;
        this.configService = configService;
        this.configUpdateService = configUpdateService;
        this.transactionTemplate = transactionTemplate;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getConfig() {
        if (!this.userUtils.isAdmin()) {
            log.error("User %s is not authorized to view configuration.", this.userUtils.getRemoteUserKey().getStringValue());
            return Response.serverError().status(403).build();
        }
        Config config = this.configService.getConfig();
        log.debug("Loaded config %s", config);
        return Response.ok((Object)config).build();
    }

    @POST
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json", "application/xml"})
    public Response setConfig(@FormParam(value="retentionPeriod") int retentionPeriod, @FormParam(value="numberOfRecordsPerPage") int numberOfRecordsPerPage, @FormParam(value="writeToSyslog") boolean writeToSyslog, @FormParam(value="syslogHost") String syslogHost, @Nullable @FormParam(value="syslogFacility") Integer syslogFacility, @Nullable @FormParam(value="syslogLevel") Integer syslogLevel, @FormParam(value="writeToFile") boolean writeToFile, @FormParam(value="filePath") String filePath) {
        if (!this.userUtils.isAdmin()) {
            log.error("User %s is not authorized to edit configuration.", this.userUtils.getRemoteUserKey().getStringValue());
            return Response.serverError().status(403).build();
        }
        Config config = this.configService.getConfig();
        config.setRetentionPeriod(retentionPeriod);
        config.setNumberOfRecordsPerPage(numberOfRecordsPerPage);
        config.setWriteToSyslog(writeToSyslog);
        config.setSyslogHost(syslogHost);
        config.setSyslogFacility(syslogFacility != null ? syslogFacility : -1);
        config.setSyslogLevel(syslogLevel != null ? syslogLevel : -1);
        config.setWriteToFile(writeToFile);
        config.setFilePath(filePath);
        List<String> errors = this.validate(config);
        if (errors.isEmpty()) {
            this.executor.execute(() -> this.transactionTemplate.execute(() -> {
                this.configUpdateService.updateConfig(config);
                return null;
            }));
        }
        return Response.ok(errors).build();
    }

    private List<String> validate(Config config) {
        Integer syslogLevel;
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isWriteToFile() && !this.fileUtils.initFile(config.getFilePath())) {
            errors.add("Invalid log file path.");
        }
        if ((syslogLevel = Integer.valueOf(config.getSyslogLevel())) == -1 || ConfigService.OLD_TO_NEW_SEVERITY_MAP.keySet().contains((Object)syslogLevel)) {
            errors.add("Severity and facility lists were updated after the latest plugin version installation. Please <a href=\"javascript:window.location.reload(true)\">reload the page</a> and try again.");
        }
        return errors;
    }
}

