/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser.rest;

import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.confluence.recordparser.rest.BulkRestUriMatchingParser;
import com.enhancera.accesslog.confluence.util.ConfluenceApiContentRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceUriRegexp;
import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.math.NumberUtils;

public class ChildPagesRestViewRecordParser
extends BulkRestUriMatchingParser {
    private final ConfluenceContentUtils contentUtils;

    public ChildPagesRestViewRecordParser(ConfluenceContentUtils contentUtils) {
        super(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_CHILD_PAGES_OF_CONTENT_URI);
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        ConfluenceApiContentRecordsParserUtils.addUserToThreadLocal(requestData.getUserKey());
        return this.parseRestGetContentRecords(requestData);
    }

    ImmutableList<AccessRecord> parseRestGetContentRecords(RequestData requestData) {
        Long contentId = RecordParserUtils.parseOptionalValue("contentId", RequestUtils.parseUriParamLong(requestData.getContextPath().concat(ConfluenceUriRegexp.RecordParserUriRegexp.REGEXP_REST_CHILD_PAGES_OF_CONTENT_URI), requestData.getUri(), "contentId"));
        String parentVersion = requestData.getRequestParameterValue("parentVersion").orElse(null);
        String start = requestData.getRequestParameterValue("start").orElse(null);
        String limit = requestData.getRequestParameterValue("limit").orElse(null);
        return ConfluenceRecordsParserUtils.parseViewPagesAccessRecords(requestData.getUserKey(), requestData.getIpAddress(), this.contentUtils.getChildPages(contentId, NumberUtils.toInt(parentVersion), NumberUtils.toInt(start), NumberUtils.toInt(limit, 25)));
    }
}

