/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.rest;

import com.enhancera.accesslog.common.DataOptionType;
import com.enhancera.accesslog.common.DataOptionsProvider;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.UserUtils;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/filter")
public class FilterDataResource {
    private static final FormattingLogger log = FormattingLogger.getLogger(FilterDataResource.class);
    private final DataOptionsProvider dataOptionsProvider;
    private final UserUtils userUtils;

    public FilterDataResource(DataOptionsProvider dataOptionsProvider, UserUtils userUtils) {
        this.dataOptionsProvider = dataOptionsProvider;
        this.userUtils = userUtils;
    }

    @Path(value="/{option}/{param}")
    @GET
    @Produces(value={"application/json"})
    public Response getObjectOptions(@PathParam(value="option") DataOptionType option, @PathParam(value="param") String param) {
        if (!this.userUtils.isAdmin()) {
            log.error("User %s is not authorized to view audit trail.", this.userUtils.getRemoteUserKey());
            return Response.serverError().status(403).build();
        }
        return Response.ok(this.dataOptionsProvider.findDataOptions(option, param, false)).build();
    }
}

