/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.data;

import com.enhancera.accesslog.common.data.SortKey;
import com.enhancera.accesslog.common.data.SortParam;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class SortParams {
    private SortParamsStack params = new SortParamsStack();

    public SortParams() {
    }

    public SortParams(SortParam sortParam) {
        this.put(sortParam);
    }

    public SortParams(List<SortParam> sortParams) {
        for (SortParam sortParam : sortParams) {
            this.put(sortParam);
        }
    }

    public void put(SortParam param) {
        this.params.push(param);
    }

    public ImmutableList<SortParam> currentOrder() {
        return this.params.currentOrder();
    }

    public String toString() {
        return this.currentOrder().stream().map(SortParam::toString).collect(Collectors.joining(", "));
    }

    private class SortParamsStack {
        private LinkedList<SortParam> params = new LinkedList();

        private SortParamsStack() {
        }

        public void push(SortParam param) {
            this.remove(param.getKey());
            this.params.addFirst(param);
        }

        public ImmutableList<SortParam> currentOrder() {
            return ImmutableList.copyOf(this.params);
        }

        private void remove(SortKey key) {
            for (SortParam p : this.params) {
                if (!p.getKey().equals((Object)key)) continue;
                this.params.remove(p);
                return;
            }
        }
    }
}

