/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common;

import com.enhancera.accesslog.common.rest.AccessRecordApi;
import com.enhancera.accesslog.common.util.MoreObjects;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="log")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PagedAccessRecords {
    public static final Integer START_PAGE = 1;
    private List<AccessRecordApi> accessRecordsApi;
    private int pageNumber;
    private int totalSize;
    private int startResult;
    private int endResult;
    private int lastPage;
    private int prevPage;
    private int nextPage;
    private boolean isFirstPage;
    private boolean isLastPage;
    private boolean showPrevPage;
    private boolean showNextPage;
    private boolean showPrevEllipsis;
    private boolean showNextEllipsis;

    public PagedAccessRecords() {
        throw new UnsupportedOperationException("No-arg constructor is just to make JAXB happy");
    }

    public PagedAccessRecords(List<AccessRecordApi> accessRecordsApi, int startIndex, int pageNumber, int resultsPerPage, int totalSize) {
        this.accessRecordsApi = accessRecordsApi;
        this.pageNumber = pageNumber;
        this.totalSize = totalSize;
        this.startResult = startIndex + 1;
        this.endResult = startIndex + accessRecordsApi.size();
        this.lastPage = (totalSize - 1) / resultsPerPage + 1;
        this.isFirstPage = startIndex == 0;
        boolean bl = this.isLastPage = this.endResult == totalSize;
        if (pageNumber > 1) {
            this.prevPage = pageNumber - 1;
        }
        this.showPrevPage = pageNumber > 2;
        boolean bl2 = this.showPrevEllipsis = pageNumber > 3;
        if (pageNumber < this.lastPage) {
            this.nextPage = pageNumber + 1;
        }
        this.showNextPage = pageNumber < this.lastPage - 1;
        this.showNextEllipsis = pageNumber < this.lastPage - 2;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accessRecords", this.accessRecordsApi).add("pageNumber", (Object)this.pageNumber).add("totalSize", (Object)this.totalSize).add("startResult", (Object)this.startResult).add("endResult", (Object)this.endResult).add("prevPage", (Object)this.prevPage).add("nextPage", (Object)this.nextPage).add("showPrevPage", (Object)this.showPrevPage).add("showNextPage", (Object)this.showNextPage).add("showPrevEllipsis", (Object)this.showPrevEllipsis).add("showNextEllipsis", (Object)this.showNextEllipsis).add("isFirstPage", (Object)this.isFirstPage).add("isLastPage", (Object)this.isLastPage).toString();
    }
}

