// Updates progress bar on global Access log status page.

AJS.toInit(function() {
  checkAccessLogStatus();
});

function checkAccessLogStatus() {
  AJS.$.ajax({
    url: AJS.contextPath() + "/rest/accesslog/1.0/access",
    type: "GET",
    success: function (currentProgress) {
      if (currentProgress) {
        AJS.$("#global-access-log-status").text("Access log is not accessible at the moment.");
        AJS.$("#current-task-name").text(currentProgress.name);
        AJS.progressBars.update("#current-task-progress-bar", currentProgress.progress);
        AJS.$("#current-task-status").text("is running");
        AJS.$('#current-task-information').show();
      } else {
        AJS.$("#global-access-log-status").text("Access log is accessible.");
        AJS.$('#current-task-information').hide();

        // waiting a few seconds to make sure all post-task processes are completed
        setTimeout(function() {
          window.location.replace(AJS.contextPath() + "/plugins/servlet/accesslog/view"); 
        }, 2000);
      }
      setTimeout(checkAccessLogStatus, 2000);
    },
    error: function(error) {
      // when unauthorized status code then redirect to login page
      if(error.status == 401) {
         window.location.replace(
           + AJS.contextPath() + "/login.jsp?permissionViolation=true&os_destination="
           + AJS.contextPath() + "/plugins/servlet/accesslog/status");
      }
      setTimeout(checkAccessLogStatus, 2000);
    }
  });
}
