/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser;

import com.atlassian.confluence.pages.AbstractPage;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.UriMatchingNonHeadParser;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceWebRecordsParserUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import java.util.Optional;

public class ViewPageSourceRecordsParser
extends UriMatchingNonHeadParser {
    private final ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils;
    private final ConfluenceContentUtils contentUtils;

    public ViewPageSourceRecordsParser(ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils, ConfluenceContentUtils contentUtils) {
        super("/plugins/viewsource/viewpagesrc.action");
        this.confluenceWebRecordsParserUtils = confluenceWebRecordsParserUtils;
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        Optional<String> pageIdStr = requestData.getRequestParameterValue("pageId");
        Long pageId = pageIdStr.isPresent() ? Longs.tryParse((String)pageIdStr.get()) : null;
        Optional<AbstractPage> pageOptional = this.contentUtils.getAbstractPageById(pageId);
        return pageOptional.isPresent() ? this.confluenceWebRecordsParserUtils.parseViewAbstractPageAccessRecords(requestData.getUserKey(), requestData.getIpAddress(), pageOptional.get()) : ImmutableList.of();
    }
}

