/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.listener.AbstractAsyncListener;
import com.enhancera.accesslog.common.logwriters.AccessLogWriter;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.LicenseCheckResult;
import com.enhancera.accesslog.common.util.LicenseChecker;
import com.enhancera.accesslog.confluence.listener.AsyncContentEvent;
import com.enhancera.accesslog.confluence.listener.ConfluenceAsyncEventListener;
import com.enhancera.accesslog.confluence.util.ConfluenceRecordsParserUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public class ConfluenceAsyncEventListenerImpl
extends AbstractAsyncListener
implements ConfluenceAsyncEventListener {
    private static final Set<String> ATTACHMENT_EVENTS_VERSION_FOR_WHICH_NOT_NEEDED = ImmutableSet.of((Object)"attachment trashed", (Object)"attachment restored", (Object)"attachment removed");
    private final AccessLogWriter accessLogWriter;
    private final LicenseChecker licenseChecker;
    private static final FormattingLogger log = FormattingLogger.getLogger(ConfluenceAsyncEventListenerImpl.class);
    private long lastReportedTime = 0L;

    public ConfluenceAsyncEventListenerImpl(EventPublisher eventPublisher, AccessLogWriter accessLogWriter, LicenseChecker licenseChecker) {
        super(eventPublisher);
        this.accessLogWriter = accessLogWriter;
        this.licenseChecker = licenseChecker;
    }

    @Override
    @EventListener
    public void onContentEvent(AsyncContentEvent contentEvent) {
        LicenseCheckResult licenseCheckResult = this.licenseChecker.checkLicense();
        if (licenseCheckResult.isOk()) {
            this.processEvent(contentEvent.getEventName(), () -> this.accessLogWriter.write((List<AccessRecord>)ConfluenceAsyncEventListenerImpl.parseContentEventRecords(contentEvent)));
        } else if (System.currentTimeMillis() - this.lastReportedTime > 300000L) {
            log.warn("Access logging disabled due to the following reason: %s", licenseCheckResult.getMessage());
            this.lastReportedTime = System.currentTimeMillis();
        }
    }

    private static ImmutableList<AccessRecord> parseContentEventRecords(AsyncContentEvent contentEvent) {
        ImmutableList<AccessRecord> result = ATTACHMENT_EVENTS_VERSION_FOR_WHICH_NOT_NEEDED.contains(contentEvent.getEventName()) ? ConfluenceRecordsParserUtils.parseAttachmentTrashedOrRestroredOrDeletedAccessRecords(contentEvent.getUserKey(), contentEvent.getIpAddress(), contentEvent.getContentEntityObject(), contentEvent.getAction()) : ConfluenceRecordsParserUtils.parseContentAccessRecords(contentEvent.getUserKey(), contentEvent.getIpAddress(), contentEvent.getContentEntityObject(), contentEvent.getAction());
        return result;
    }
}

