/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;

public class UserUtils {
    private final UserManager userManager;

    public UserUtils(UserManager userManager) {
        this.userManager = userManager;
    }

    public UserKey getRemoteUserKey() {
        return this.userManager.getRemoteUserKey();
    }

    public UserProfile getUserProfile(UserKey userKey) {
        return this.userManager.getUserProfile(userKey);
    }

    public boolean isAdmin() {
        return this.userManager.isAdmin(this.userManager.getRemoteUserKey());
    }

    public String getUserNameOrUnknown(String userKey) {
        return this.getUserNameOrUnknown(new UserKey(userKey));
    }

    public String getUserNameOrUnknown(UserKey userKey) {
        String userName = this.getUserName(userKey);
        return userKey != null ? userName : "<unknown>";
    }

    public String getUserName(UserKey userKey) {
        UserProfile userProfile = userKey != null ? this.userManager.getUserProfile(userKey) : null;
        return userProfile != null ? userProfile.getUsername() : null;
    }

    public String getUserKeyValueByName(String username) {
        UserProfile userProfile = username != null ? this.userManager.getUserProfile(username) : null;
        UserKey userKey = userProfile != null ? userProfile.getUserKey() : null;
        return userKey != null ? userKey.getStringValue() : null;
    }

    public static String getUserKeyStr(UserKey userKey) {
        return userKey != null ? userKey.getStringValue() : null;
    }
}

