/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.data;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.enhancera.accesslog.common.data.SettingsDao;
import com.enhancera.accesslog.common.data.SettingsEntity;
import com.enhancera.accesslog.common.util.FormattingLogger;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class ActiveObjectsSettingsDao
implements SettingsDao {
    private static final FormattingLogger log = FormattingLogger.getLogger(ActiveObjectsSettingsDao.class);
    private final ActiveObjects ao;
    private final TransactionTemplate transactionTemplate;

    public ActiveObjectsSettingsDao(ActiveObjects ao, TransactionTemplate transactionTemplate) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    @Nullable
    public String get(String key) {
        return this.get(key, s -> s);
    }

    @Override
    @Nullable
    public <T> T get(String key, Function<String, T> parser) {
        SettingsEntity entity = this.getEntity(key);
        return entity == null || entity.getValue() == null ? null : (T)parser.apply(entity.getValue());
    }

    @Override
    public <T> void set(String key, T value, Function<T, String> toStringMethod) {
        this.transactionTemplate.execute(() -> {
            SettingsEntity entity = this.getEntity(key);
            if (entity == null) {
                entity = (SettingsEntity)this.ao.create(SettingsEntity.class, new DBParam[0]);
            }
            entity.setKey(key);
            entity.setValue(value == null ? null : (String)toStringMethod.apply(value));
            entity.save();
            return null;
        });
    }

    @Override
    public void set(String key, Object value) {
        this.set(key, value, o -> value.toString());
    }

    @Nullable
    private SettingsEntity getEntity(String key) {
        SettingsEntity[] entities = (SettingsEntity[])this.transactionTemplate.execute(() -> (SettingsEntity[])this.ao.find(SettingsEntity.class, Query.select().where("KEY = '" + key + "'", new Object[0])));
        if (entities.length == 0) {
            return null;
        }
        if (entities.length > 1) {
            log.warn("Multiple values stored for key " + key, new Object[0]);
        }
        return entities[0];
    }

    @Override
    public void remove(String key) {
        SettingsEntity entity = this.getEntity(key);
        if (entity != null) {
            this.transactionTemplate.execute(() -> {
                this.ao.delete(new RawEntity[]{entity});
                return null;
            });
        }
    }
}

