/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.confluence.recordparser;

import com.atlassian.confluence.pages.AbstractPage;
import com.enhancera.accesslog.common.AccessRecord;
import com.enhancera.accesslog.common.Action;
import com.enhancera.accesslog.common.RequestData;
import com.enhancera.accesslog.common.ResponseData;
import com.enhancera.accesslog.common.recordparser.RecordParserUtils;
import com.enhancera.accesslog.common.recordparser.UriMatchingNonHeadParser;
import com.enhancera.accesslog.confluence.util.ConfluenceContentUtils;
import com.enhancera.accesslog.confluence.util.ConfluenceUriRegexp;
import com.enhancera.accesslog.confluence.util.ConfluenceWebRecordsParserUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import java.util.Optional;

public class ViewExportPageRecordsParser
extends UriMatchingNonHeadParser {
    private static final String POSTING_DAY_SEPARATOR = "/";
    private final ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils;
    private final ConfluenceContentUtils contentUtils;

    public ViewExportPageRecordsParser(ConfluenceWebRecordsParserUtils confluenceWebRecordsParserUtils, ConfluenceContentUtils contentUtils) {
        super(ConfluenceUriRegexp.RecordParserUriRegexp.VIEW_EXPORT_PAGE_URI_REGEXP);
        this.confluenceWebRecordsParserUtils = confluenceWebRecordsParserUtils;
        this.contentUtils = contentUtils;
    }

    @Override
    protected ImmutableList<AccessRecord> parse(RequestData requestData, ResponseData responseData) {
        Optional<AbstractPage> pageOptional = this.getPageFromRequest(requestData);
        Action action = requestData.getUri().matches(requestData.getContextPath() + "(" + "/exportword" + "|" + "/spaces/flyingpdf/pdfpageexport.action" + ")") ? Action.EXPORT : Action.VIEW;
        return pageOptional.isPresent() ? this.confluenceWebRecordsParserUtils.parseAbstractPageAccessRecords(requestData.getUserKey(), requestData.getIpAddress(), pageOptional.get(), action) : ImmutableList.of();
    }

    Optional<AbstractPage> getPageFromRequest(RequestData requestData) {
        Optional<String> pageIdStr = requestData.getRequestParameterValue("pageId");
        Long pageId = pageIdStr.isPresent() ? Longs.tryParse((String)pageIdStr.get()) : null;
        Optional<AbstractPage> pageOptional = Optional.empty();
        if (pageId != null) {
            pageOptional = this.contentUtils.getAbstractPageById(pageId);
        } else if (!requestData.getContextPath().concat("/exportword").equals(requestData.getUri())) {
            Optional<String> spaceKey = requestData.getRequestParameterValue("spaceKey");
            Optional<String> title = requestData.getRequestParameterValue("title");
            if (!spaceKey.isPresent() || !title.isPresent()) {
                return Optional.empty();
            }
            String postingDay = RecordParserUtils.parseOptionalValue("postingDay", requestData.getRequestParameterValue("postingDay"));
            pageOptional = this.contentUtils.getAbstractPageBySpaceKeyAndTitle(spaceKey.get(), title.get(), postingDay, POSTING_DAY_SEPARATOR);
        }
        return pageOptional;
    }
}

