/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.view;

import au.com.bytecode.opencsv.CSVWriter;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.enhancera.accesslog.HostAppService;
import com.enhancera.accesslog.common.RecordCriteria;
import com.enhancera.accesslog.common.database.DataLayer;
import com.enhancera.accesslog.common.rest.AccessRecordApi;
import com.enhancera.accesslog.common.servlet.GlobalAccessServletRedirect;
import com.enhancera.accesslog.common.util.FormattingLogger;
import com.enhancera.accesslog.common.util.LicenseCheckResult;
import com.enhancera.accesslog.common.util.LicenseChecker;
import com.enhancera.accesslog.common.util.RequestUtils;
import com.enhancera.accesslog.common.util.UserUtils;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

public class CsvExportServlet
extends HttpServlet {
    private static final String DATE_TIME_FORMAT = "yyyyMMdd-HHmmss";
    private static final String FILE_NAME_FORMAT = "%s-access-log-%s.csv";
    private static final String CONTENT_TYPE = "text/csv";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final String CONTENT_DISPOSITION_VALUE_FORMAT = "attachment; filename=\"%s\"";
    private static final FormattingLogger log = FormattingLogger.getLogger(CsvExportServlet.class);
    private static final String[] CSV_HEADER = new String[]{"Time", "User", "Ip Address", "Content Type", "Content Id", "Action"};
    private final DataLayer dataLayer;
    private final I18nResolver i18nResolver;
    private final UserUtils userUtils;
    private final RequestUtils requestUtils;
    private final LicenseChecker licenseChecker;
    private final HostAppService hostAppService;
    private final GlobalAccessServletRedirect globalAccessServletRedirect;

    public CsvExportServlet(DataLayer dataLayer, I18nResolver i18nResolver, UserUtils userUtils, RequestUtils requestUtils, HostAppService hostAppService, GlobalAccessServletRedirect globalAccessServletRedirect, PluginLicenseManager pluginLicenseManager) {
        this.dataLayer = dataLayer;
        this.i18nResolver = i18nResolver;
        this.userUtils = userUtils;
        this.requestUtils = requestUtils;
        this.licenseChecker = new LicenseChecker(pluginLicenseManager, i18nResolver);
        this.hostAppService = hostAppService;
        this.globalAccessServletRedirect = globalAccessServletRedirect;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            this.globalAccessServletRedirect.redirectIfNotAccessible(request, response);
            if (!this.userUtils.isAdmin()) {
                this.requestUtils.redirectToLoginPage(request, response);
                return;
            }
            response.setContentType(CONTENT_TYPE);
            String filename = String.format(FILE_NAME_FORMAT, this.hostAppService.getApplicationName(), DateTimeFormat.forPattern((String)DATE_TIME_FORMAT).print((ReadableInstant)DateTime.now()));
            response.setHeader(CONTENT_DISPOSITION_HEADER, String.format(CONTENT_DISPOSITION_VALUE_FORMAT, filename));
            try (CSVWriter writer = new CSVWriter(response.getWriter());){
                LicenseCheckResult licenseCheckResult = this.licenseChecker.checkLicense();
                if (!licenseCheckResult.isOk()) {
                    log.error("Access logging disabled due to the following reason: %s", licenseCheckResult.getMessage());
                    writer.writeNext(new String[]{licenseCheckResult.getMessage()});
                } else {
                    String[] sortParams = request.getParameterValues("sortParams");
                    writer.writeNext(CSV_HEADER);
                    this.dataLayer.readRecords(RecordCriteria.create(request), RequestUtils.parseSortParams(sortParams != null ? Arrays.asList(sortParams) : null), record -> writer.writeNext(this.parseRecordParams(record)));
                }
            }
        }
        catch (IOException e) {
            log.error(e, "IO error while exporting records to CSV file.", new Object[0]);
        }
    }

    private String[] parseRecordParams(AccessRecordApi record) {
        String user = record.getUser();
        return new String[]{record.getTime(), user != null ? user : "<unknown>", record.getIpAddress(), this.i18nResolver.getText(record.getContentType()), record.getContentId(), this.i18nResolver.getText(record.getAction())};
    }
}

