/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.util;

import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.config.ConfigService;
import com.enhancera.accesslog.common.util.FormattingLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nullable;
import org.apache.tika.Tika;

public class FileUtils {
    private static final FormattingLogger log = FormattingLogger.getLogger(FileUtils.class);
    private final ConfigService configService;

    public FileUtils(ConfigService configService) {
        this.configService = configService;
    }

    public boolean initFile(@Nullable String pathString) {
        Config config = this.configService.getConfig();
        if (config.isWriteToFile() && config.getFilePath().equals(pathString)) {
            return true;
        }
        try {
            Tika tika;
            String mimeType;
            if (pathString == null) {
                log.error("File path is null", new Object[0]);
                return false;
            }
            Path path = Paths.get(pathString, new String[0]);
            if (path.toFile().exists() && ((mimeType = (tika = new Tika()).detect(path)) == null || !mimeType.equals("text/plain") && !mimeType.equals("text/x-log"))) {
                return false;
            }
            FileUtils.writeToFile(("Access log file initialized." + System.lineSeparator()).getBytes(), path);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static synchronized void writeToFile(byte[] meessageBytes, Path filePath) throws IOException {
        Files.write(filePath, meessageBytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
    }
}

