/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.accesslog.common.config;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.Severity;
import com.enhancera.accesslog.common.config.Config;
import com.enhancera.accesslog.common.config.ConfigDao;
import com.google.common.collect.ImmutableMap;

public class ConfigService {
    public static final ImmutableMap<Integer, Integer> OLD_TO_NEW_SEVERITY_MAP = ImmutableMap.builder().put((Object)10000, (Object)Severity.DEBUG.numericalCode()).put((Object)20000, (Object)Severity.INFORMATIONAL.numericalCode()).put((Object)30000, (Object)Severity.WARNING.numericalCode()).put((Object)40000, (Object)Severity.ERROR.numericalCode()).put((Object)50000, (Object)Severity.EMERGENCY.numericalCode()).build();
    private static final ImmutableMap<Integer, Integer> OLD_TO_NEW_FACILITY_MAP = ImmutableMap.builder().put((Object)0, (Object)Facility.KERN.numericalCode()).put((Object)8, (Object)Facility.USER.numericalCode()).put((Object)16, (Object)Facility.MAIL.numericalCode()).put((Object)24, (Object)Facility.DAEMON.numericalCode()).put((Object)32, (Object)Facility.AUTH.numericalCode()).put((Object)40, (Object)Facility.SYSLOG.numericalCode()).put((Object)48, (Object)Facility.LPR.numericalCode()).put((Object)56, (Object)Facility.NEWS.numericalCode()).put((Object)64, (Object)Facility.UUCP.numericalCode()).put((Object)72, (Object)Facility.CRON.numericalCode()).put((Object)80, (Object)Facility.AUTHPRIV.numericalCode()).put((Object)88, (Object)Facility.FTP.numericalCode()).put((Object)128, (Object)Facility.LOCAL0.numericalCode()).put((Object)136, (Object)Facility.LOCAL1.numericalCode()).put((Object)144, (Object)Facility.LOCAL2.numericalCode()).put((Object)152, (Object)Facility.LOCAL3.numericalCode()).put((Object)160, (Object)Facility.LOCAL4.numericalCode()).put((Object)168, (Object)Facility.LOCAL5.numericalCode()).put((Object)176, (Object)Facility.LOCAL6.numericalCode()).put((Object)184, (Object)Facility.LOCAL7.numericalCode()).build();
    private final ConfigDao dao;

    public ConfigService(ConfigDao dao) {
        this.dao = dao;
    }

    public Config getConfig() {
        int syslogLevel;
        Config config = this.dao.load();
        if (config == null) {
            config = new Config();
            this.dao.save(config);
        }
        if (OLD_TO_NEW_SEVERITY_MAP.containsKey((Object)(syslogLevel = config.getSyslogLevel()))) {
            config.setSyslogLevel((Integer)OLD_TO_NEW_SEVERITY_MAP.get((Object)syslogLevel));
            int syslogFacility = config.getSyslogFacility();
            if (OLD_TO_NEW_FACILITY_MAP.containsKey((Object)syslogFacility)) {
                config.setSyslogFacility((Integer)OLD_TO_NEW_FACILITY_MAP.get((Object)syslogFacility));
            }
            this.dao.save(config);
        }
        return config;
    }

    public void setConfig(Config config) {
        this.dao.save(config);
    }
}

