var enhanceraAuditor = (function () {

  const SECONDS_PER_DAY = 86400;

  // Saved values for future requests.
  var page = 1;
  var query = '';

  // Prevent clashing with other addons Handlebars versions
  var auditorHandlebars = Handlebars;
  Handlebars.noConflict();

  var filter = {
    fromTime: null,
    toTime: null,
    users: null,
    ips: null,
    categories: null,
    summaries: null,
    objects: null
  };

  self.init = function (pageParam, queryParam) {
    page = pageParam;
    query = queryParam;
    setUpSearch();
    setUpFilter();
    submitFilter(page);
    setUpSettings();
    setUpCleanOption();
    initDialog2CloseIcons();
  }

  function setUpCleanOption() {
    AJS.$('#cleanLogButton').click(function () {
      AJS.dialog2('#deleteWarningDialog').show();
    });
    AJS.$('#confirmDelete').click(function () {
      cleanAuditLog();
    });
    AJS.$('#deleteCancel').click(function () {
      AJS.dialog2('#deleteWarningDialog').hide();
    });
  }

  function cleanAuditLog() {
    var url = AJS.contextPath() + '/rest/auditlog/1.0/trail';
    AJS.$.ajax({
      url: url,
      type: "DELETE",
      contentType: "application/json",
      success: function (res) {
        AJS.dialog2("#deleteWarningDialog").hide();
        update(1);
      }
    });
  }

  function update(page) {

    history.pushState(null, null, AJS.contextPath()
        + '/plugins/servlet/auditor/trail?page=' + page + '&' + getUrlParameters());

    var url = AJS.contextPath() + '/rest/auditlog/1.0/trail.json' +
        '?page=' + page + '&' + getUrlParameters();
    AJS.$.ajax({
      url: url,
      dataType: "json"
    }).done(function (trail) {
      AJS.$("#page").val(trail.events.length);
      setPaginationInfo(trail);
      clearTable();
      for (var i = 0; i < trail.events.length; i++) {
        var event = trail.events[i];
        appendRow(event);
      }
      setUpShowMoreExpanders();
    });
  }

  function clearTable() {
    AJS.$('#event-table > tbody > tr').remove();
  }

  function appendRow(event) {
    AJS.$('#event-table > tbody')
        .append(renderTemplate('event-summary-template', event))
        .append(renderTemplate('event-details-template', event));
  }

  function setUpShowMoreExpanders() {
    AJS.$('.show-more').click(function () {
      var showMore = AJS.I18n.getText('auditor.trail.table.details.show-more');
      var showLess = AJS.I18n.getText('auditor.trail.table.details.show-less');
      AJS.$(this).text(AJS.$(this).text().trim() === showMore ? showLess : showMore)
      AJS.$(this).parent().parent().next().toggle();
    });
  }

  function setPaginationInfo(trail) {
    if (trail.onLastPage) {
      AJS.$('#last-page-info').show();
    } else {
      AJS.$('#last-page-info').hide();
    }
    AJS.$('.page-info').html(renderTemplate('page-info-template', trail));
    AJS.$('.pagination-control a[page-num]').click(function (e) {
      e.preventDefault();
      if (AJS.$(this).attr('aria-disabled')) {
        return;
      }
      var page = AJS.$(this).attr('page-num');
      update(page);
    });
  }

  function setUpSearch() {
    AJS.$('#search-form').submit(function (e) {
      e.preventDefault();
      query = AJS.$('#search-box').val().trim();
      update(1);
    });
  }

  function setUpFilter() {

    function getAjaxSelect2Params(paramName, data) {
      return {
        multiple: true,
        minimumInputLength: 3,
        ajax: {
          delay: 250,
          url: function (param) {
            return AJS.contextPath() + '/rest/auditlog/1.0/filter/' + paramName + '/' + param;
          },
          dataType: 'json',
          type: 'GET',
          results: function (data) {
            return {
              results: data
            };
          }
        }
      }
    }

    AJS.$('#search-box').val(query);

    AJS.$('#date-picker-from').datePicker({'overrideBrowserDefault': true});
    AJS.$('#date-picker-from').attr("placeholder", "yyyy-mm-dd");
    AJS.$('#date-picker-to').datePicker({'overrideBrowserDefault': true});
    AJS.$('#date-picker-to').attr("placeholder", "yyyy-mm-dd");

    AJS.$('#filter-user-select').auiSelect2(getAjaxSelect2Params('AUTHOR'));
    AJS.$('#filter-ip-select').auiSelect2(getAjaxSelect2Params('IP'));
    AJS.$('#filter-category-select').auiSelect2(getAjaxSelect2Params('CATEGORY'));
    AJS.$('#filter-summary-select').auiSelect2(getAjaxSelect2Params('SUMMARY'));
    AJS.$('#filter-object-select').auiSelect2(getAjaxSelect2Params('OBJECT'));

    function loadFilter() {
      // yyyy-mm-dd
      function formatDate(date) {
        return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
      }

      if (filter.fromTime) {
        AJS.$('#date-picker-from').val(formatDate(new Date(filter.fromTime)));
      }
      if (filter.toTime) {
        AJS.$('#date-picker-to').val(formatDate(new Date(filter.toTime)));
      }
      AJS.$('#filter-user-select').select2('data', filter.users).trigger("change");
      AJS.$('#filter-ip-select').select2('data', filter.ips).trigger("change");
      AJS.$('#filter-category-select').select2('data', filter.categories).trigger('change');
      AJS.$('#filter-summary-select').select2('data', filter.summaries).trigger('change');
      AJS.$('#filter-object-select').select2('data', filter.objects).trigger('change');
    }

    loadFilter();

    AJS.$('#filter-dialog-show-button').click(function () {
      loadFilter();
      AJS.dialog2('#filter-dialog').show();
    });
    AJS.$('#filter-dialog-close-button').click(function (e) {
      e.preventDefault();
      AJS.dialog2('#filter-dialog').hide();
    });
    AJS.$('#filter-clean-button').click(function (e) {
      e.preventDefault();
      AJS.$('#date-picker-from').val("");
      AJS.$('#date-picker-to').val("");
      AJS.$('#filter-user-select').select2('data', null).trigger("change");
      AJS.$('#filter-ip-select').select2('data', null).trigger("change");
      AJS.$('#filter-category-select').select2('data', null).trigger("change");
      AJS.$('#filter-summary-select').select2('data', null).trigger("change");
      AJS.$('#filter-object-select').select2('data', null).trigger("change");
      AJS.$('#date-picker-to-error').hide();
      AJS.$('#date-picker-from-error').hide();
    });
    AJS.$('#filter-dialog-submit-button').click(function (e) {
      e.preventDefault();
      submitFilter(1);
    });
  }

  function submitFilter(page) {
    var isValid = true;

    var fromDateString = AJS.$('#date-picker-from').val();
    if (isEmpty(fromDateString)) {
      filter.fromTime = null;
      AJS.$('#date-picker-from-error').hide();
    } else {
      var date = parseDate(fromDateString);
      if (date) {
        filter.fromTime = date.valueOf();
        AJS.$('#date-picker-from-error').hide();
      } else {
        filter.fromTime = null;
        AJS.$('#date-picker-from-error').text('Incorrect date format, should be yyyy-mm-dd');
        AJS.$('#date-picker-from-error').show();
        isValid = false;
      }
    }

    var toDateString = AJS.$('#date-picker-to').val();
    if (isEmpty(toDateString)) {
      filter.toTime = null;
      AJS.$('#date-picker-to-error').hide();
    } else {
      var date = parseDate(toDateString);
      if (date) {
        filter.toTime = date.valueOf();
        AJS.$('#date-picker-to-error').hide();
      } else {
        filter.toTime = null;
        AJS.$('#date-picker-to-error').text('Incorrect date format, should be yyyy-mm-dd');
        AJS.$('#date-picker-to-error').show();
        isValid = false;
      }
    }

    if (fromDateString && toDateString && filter.fromTime >= filter.toTime) {
      AJS.$('#date-picker-to-error').text('"Before" field should have date > date in the "After" field.');
      AJS.$('#date-picker-to-error').show();
      return;
    }

    filter.users = AJS.$('#filter-user-select').select2('data');
    filter.ips = AJS.$('#filter-ip-select').select2('data');
    filter.categories = AJS.$('#filter-category-select').select2('data');
    filter.summaries = AJS.$('#filter-summary-select').select2('data');
    filter.objects = AJS.$('#filter-object-select').select2('data');

    if (isValid) {
      update(page);
      var filterConditionCount = 0;
      if (filter.toTime || filter.fromTime) {
        filterConditionCount++;
      }
      if (filter.users && filter.users.length > 0) {
        filterConditionCount++;
      }
      if (filter.ips && filter.ips.length > 0) {
        filterConditionCount++;
      }
      if (filter.categories && filter.categories.length > 0) {
        filterConditionCount++;
      }
      if (filter.summaries && filter.summaries.length > 0) {
        filterConditionCount++;
      }
      if (filter.objects && filter.objects.length > 0) {
        filterConditionCount++;
      }
      var filterSummary = filterConditionCount ? " (" + filterConditionCount + ")" : "";
      AJS.$('#filter-summary').text(filterSummary);
      AJS.dialog2('#filter-dialog').hide();
    }
  }

  function isEmpty(string) {
    return !string || !string.trim();
  }

  /*
   * returns null if dateString is not valid yyyy-mm-dd
   */
  function parseDate(dateString) {
    if (isNaN(new Date(dateString).valueOf())) {
      return null;
    }
    var parts = dateString.split("-");
    var year = parts[0];
    var month = parts[1] - 1; // months are zero indexed
    var day = parts[2];
    var date = new Date(year, month, day);
    return date;
  }

  function getUrlParameters() {
    var res = 'query=' + query;
    if (filter.fromTime) {
      res += '&fromTime=' + encodeURIComponent(filter.fromTime);
    }
    if (filter.toTime) {
      res += '&toTime=' + encodeURIComponent(filter.toTime);
    }
    if (filter.users) {
      for (var i = 0; i < filter.users.length; i++) {
        res += '&users=' + encodeURIComponent(filter.users[i].text);
      }
    }
    if (filter.ips) {
      for (var i = 0; i < filter.ips.length; i++) {
        res += '&ips=' + encodeURIComponent(filter.ips[i].text);
      }
    }
    if (filter.categories) {
      for (var i = 0; i < filter.categories.length; i++) {
        res += '&categories=' + encodeURIComponent(filter.categories[i].text);
      }
    }
    if (filter.summaries) {
      for (var i = 0; i < filter.summaries.length; i++) {
        res += '&summaries=' + encodeURIComponent(filter.summaries[i].text);
      }
    }
    if (filter.objects) {
      for (var i = 0; i < filter.objects.length; i++) {
        res += '&objects=' + encodeURIComponent(filter.objects[i].text);
      }
    }
    return res;
  }

  function loadSettings(callback) {
    var url = AJS.contextPath() + '/rest/auditlog/1.0/settings.json';
    AJS.$.ajax({url: url, method: 'GET', dataType: "json"}).done(callback);
  }

  function saveSettings(settings, callback) {
    var url = AJS.contextPath() + '/rest/auditlog/1.0/settings.json';
    AJS.$.ajax({
      url: url,
      headers: {'X-Atlassian-Token': 'no-check'},
      type: 'POST',
      data: settings
    })
        .done(function (errors) {
          AJS.$('#config-error-message-details').empty();
          if (!AJS.$.isEmptyObject(errors)) {
            var errorDetails = AJS.$('#config-error-message-details');
            for (var i = 0; i < errors.length; i++) {
              errorDetails.append("<li>" + errors[i] + "</li>");
            }
            AJS.$('#config-error-message').show();
          } else {
            AJS.$('#config-error-message').hide();
            callback();
          }
        });
  }

  function renderTemplate(templateId, context) {
    var source = AJS.$("#" + templateId).html();
    var template = auditorHandlebars.compile(source);
    context.baseUrl = AJS.contextPath();
    return template(context);
  }

  function csvExport() {
    window.location.assign(AJS.contextPath()
        + "/plugins/servlet/auditor/audit-log.csv?" + getUrlParameters());
  }


  function setUpSettings() {
    AJS.$('#notifiedUsers').auiSelect2();
    // Hides the dialog without saving.
    AJS.$("#settings-dialog-close-button").click(function (e) {
      e.preventDefault();
      AJS.dialog2("#settings-dialog").hide();
    });
    // Saves settings and hides the dialog.
    AJS.$("#settings-dialog-submit-button").click(function (e) {
      e.preventDefault();
      saveSettings({
        retentionPeriod: AJS.$('#retention-period').val(),
        numberOfEventsPerPage: AJS.$('#number-of-events-per-page').val(),
        isSystemAdminAccessOnly: AJS.$('#systemAdminsAccessOnly').is(":checked"),
        notifiedUsers: AJS.$('#notifiedUsers').val() || [],
        writeToSyslog: AJS.$('#writeToSyslog').is(":checked"),
        syslogHost: AJS.$('#syslogHost').val(),
        syslogFacility: AJS.$('#syslogFacility').val(),
        syslogLevel: AJS.$('#syslogLevel').val(),
        writeToFile: AJS.$('#writeToFile').is(":checked"),
        filePath: AJS.$('#filePath').val()
      }, function () {
        AJS.dialog2("#settings-dialog").hide();
        update(1, query);
      });
    });

    AJS.$('#writeToSyslog').click(function () {
      AJS.$('.syslogHostDetails').toggle(this.checked);
    });

    AJS.$('#writeToFile').click(function () {
      AJS.$('.filePathDetails').toggle(this.checked);
    });

    // Initializes the dialog.
    AJS.$('#auditing-settings').click(function () {
      // Initialize from current settings.
      loadSettings(function (settings) {
        AJS.$('#retention-period').val(settings.retentionPeriod / SECONDS_PER_DAY);
        AJS.$('#number-of-events-per-page').val(settings.numberOfEventsPerPage);
        AJS.$('#systemAdminsAccessOnly').prop('checked', settings.systemAdminAccessOnly);
        AJS.$('#writeToSyslog').prop('checked', settings.writeToSyslog);
        AJS.$('#syslogHost').val(settings.syslogHost);
        AJS.$('#syslogFacility').val(settings.syslogFacility);
        AJS.$('#syslogLevel').val(settings.syslogLevel);
        if (settings.writeToSyslog) {
          AJS.$('.syslogHostDetails').show();
        } else {
          AJS.$('.syslogHostDetails').hide();
        }
        AJS.$('#writeToFile').prop('checked', settings.writeToFile);
        AJS.$('#filePath').val(settings.filePath);
        if (settings.writeToFile) {
          AJS.$('.filePathDetails').show();
        } else {
          AJS.$('.filePathDetails').hide();
        }
        var users = [];
        for (var i = 0; i < settings.notifiedUsers.length; i++) {
          users.push(settings.notifiedUsers[i].username);
        }
        AJS.$('#notifiedUsers').val(users).trigger('change');
        AJS.dialog2('#settings-dialog').show();

        AJS.$('#config-error-message-details').empty();
        AJS.$('#config-error-message').hide();
      });
    });
  }


  // cross-version compatibility for dialog2 close icons
  // Jira 8.12+ uses different type of icons
  function initDialog2CloseIcons() {
    AJS.$('.aui-dialog2-header-close').click(function () {
      AJS.dialog2('#' + AJS.$(this).closest('section').attr('id')).hide();
    });
  }

  var api = {
    page: page,
    query: query,
    filter: filter,
    init: init,
    csvExport: csvExport
  };
  return api;
})();