/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.schedule.ScheduledJobKey;
import com.atlassian.confluence.schedule.managers.ScheduledJobManager;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.spring.container.ContainerManager;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.StringUtils;
import java.lang.reflect.Method;
import java.util.List;

public class JobScheduleByIdTransformer
implements Transformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(JobScheduleByIdTransformer.class);
    private final ScheduledJobManager scheduledJobManager = this.getScheduledJobManager();

    private ScheduledJobManager getScheduledJobManager() {
        return (ScheduledJobManager)ContainerManager.getComponent((String)"scheduledJobManager");
    }

    @Override
    public List<String> transform(List<String> args) {
        String group = args.get(0);
        String id = args.get(1);
        JobId jobId = JobId.of((String)id);
        ScheduledJobKey jobKey = StringUtils.isNullOrBlank(group) ? new ScheduledJobKey(id) : new ScheduledJobKey(group, id);
        return ConvertionUtils.values(this.getCronExpressionOutput(jobId, jobKey));
    }

    private String getCronExpressionOutput(JobId jobId, ScheduledJobKey jobKey) {
        try {
            Method method = this.scheduledJobManager.getClass().getMethod("getCronExpression", JobId.class);
            return (String)method.invoke((Object)this.scheduledJobManager, jobId);
        }
        catch (NoSuchMethodException e) {
            try {
                Method legacyMethod = this.scheduledJobManager.getClass().getMethod("getCronExpression", ScheduledJobKey.class);
                return (String)legacyMethod.invoke((Object)this.scheduledJobManager, jobKey);
            }
            catch (Exception ex) {
                log.error("Failed to call getCronExpression with ScheduledJobKey", ex);
                return "None";
            }
        }
        catch (Exception e) {
            log.error("Failed to call getCronExpression with JobId", e);
            return "None";
        }
    }
}

