/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.servlet.jakarta.util;

import com.atlassian.sal.api.web.context.HttpContext;
import com.enhancera.auditor.common.rest.GenericHttpRequest;
import com.enhancera.auditor.common.util.IpExtractor;
import com.enhancera.servlet.jakarta.rest.JakartaHttpRequestAdapter;
import com.enhancera.servlet.jakarta.util.RequestUtils;
import jakarta.servlet.http.HttpServletRequest;

public class JakartaIpExtractor
implements IpExtractor {
    private final HttpContext httpContext;

    public JakartaIpExtractor(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    @Override
    public String extractIpAddress(GenericHttpRequest request) {
        if (!(request instanceof JakartaHttpRequestAdapter)) {
            return "-";
        }
        JakartaHttpRequestAdapter jakartaHttpRequest = (JakartaHttpRequestAdapter)request;
        return RequestUtils.extractIpAddress(jakartaHttpRequest.getDelegate());
    }

    @Override
    public GenericHttpRequest getCurrentRequest() {
        return new JakartaHttpRequestAdapter(this.httpContext.getRequest());
    }

    @Override
    public String getCurrentIp() {
        HttpServletRequest request = this.httpContext.getRequest();
        return RequestUtils.extractIpAddress(request);
    }
}

