/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.enhancera.auditor.common.transformers.SingleValueTransformer;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Preconditions;
import java.util.List;

public class SpaceHomePageTitleByKeyTransformer
extends SingleValueTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(SpaceHomePageTitleByKeyTransformer.class);
    private final SpaceManager spaceManager;

    public SpaceHomePageTitleByKeyTransformer(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    @Override
    public String transformSingle(List<String> args) {
        Preconditions.checkArgument(args.size() == 1);
        String spaceKey = args.get(0);
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            log.debug("Space not found for key %s.", spaceKey);
            return null;
        }
        Page spaceHomePage = space.getHomePage();
        if (spaceHomePage == null) {
            log.debug("Space home page not found for space key %s.", spaceKey);
            return null;
        }
        String spaceHomePageTitle = spaceHomePage.getTitle();
        log.debug("Space home page title for key %s is '%s'.", spaceKey, spaceHomePageTitle);
        return spaceHomePageTitle;
    }
}

