/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.confluence.transformers.PageTitleByIdTransformer;
import com.google.common.collect.Iterables;
import java.util.List;

public class SpaceExportParametersTransformer
implements Transformer {
    private final PageTitleByIdTransformer pageTitleByIdTransformer;

    public SpaceExportParametersTransformer(PageTitleByIdTransformer pageTitleByIdTransformer) {
        this.pageTitleByIdTransformer = pageTitleByIdTransformer;
    }

    @Override
    public List<String> transform(List<String> args) {
        String contentOption;
        String exportType = null;
        String includeComments = null;
        String exportedPages = null;
        String excludedPages = null;
        switch (contentOption = args.get(0)) {
            case "all": {
                exportType = "Full space export";
                break;
            }
            case "visibleOnly": {
                exportType = "Normal export";
                break;
            }
            default: {
                exportType = "Custom export";
                includeComments = args.get(1) == null ? "false" : args.get(1);
                exportedPages = args.get(2) == null ? "<None>" : Iterables.getOnlyElement(this.pageTitleByIdTransformer.transform(args.get(2)));
                excludedPages = args.get(3) == null ? "<None>" : Iterables.getOnlyElement(this.pageTitleByIdTransformer.transform(args.get(3)));
            }
        }
        return ConvertionUtils.values(exportType, includeComments, exportedPages, excludedPages);
    }
}

