/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence;

import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.OptionalUtils;
import com.enhancera.auditor.confluence.OsgiUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.context.ApplicationContext;

public class GadgetService {
    private static final FormattingLogger log = FormattingLogger.getLogger(GadgetService.class);
    private Object gadgetManager;

    private void loadBeansFromGadgetsSpiContext() {
        ApplicationContext appCtx;
        if (this.gadgetManager == null && (appCtx = OptionalUtils.parseOptionalValue("gadgetsSpiAppCtx", OsgiUtils.getAppCtx("com.atlassian.confluence.plugins.gadgets.spi"))) != null) {
            this.gadgetManager = appCtx.getBean("subscribedGadgetFeedStore");
        }
    }

    public Optional<String> getGadgetFeed(String id) {
        this.loadBeansFromGadgetsSpiContext();
        try {
            Method getGadgetFeedMethod = this.gadgetManager.getClass().getMethod("getFeed", String.class);
            Object gadgetFeed = getGadgetFeedMethod.invoke(this.gadgetManager, id);
            return Optional.of(String.valueOf(gadgetFeed));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error(e, "Error occurred while getting gadget feed data from com.atlassian.confluence.plugins.gadgets SubscribedGadgetFeedStore class.", new Object[0]);
            return Optional.empty();
        }
    }
}

