/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.rest;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.UserImpl;
import com.enhancera.auditor.common.rest.ServiceResponse;
import com.enhancera.auditor.common.settings.PersistentSettingsServiceImpl;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FileUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.UserUtils;
import com.google.common.collect.ImmutableCollection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class SettingsRestResourceExecutor {
    private static final FormattingLogger log = FormattingLogger.getLogger(SettingsRestResourceExecutor.class);
    private final UserManager userManager;
    private final UserUtils userUtils;
    private final SettingsService settingsService;
    private final FileUtils fileUtils;

    public SettingsRestResourceExecutor(UserManager userManager, UserUtils userUtils, SettingsService settingsService, FileUtils fileUtils) {
        this.userManager = userManager;
        this.userUtils = userUtils;
        this.settingsService = settingsService;
        this.fileUtils = fileUtils;
    }

    public ServiceResponse getSettings() {
        User user = this.userUtils.getCurrentUser();
        String username = user == null ? null : user.getUsername();
        Settings settings = this.settingsService.getSettings();
        if (username == null || !this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            log.error("User %s is not authorized to view settings.", user);
            return ServiceResponse.serverError().status(403).build();
        }
        log.debug("Loaded settings %s", settings);
        return ServiceResponse.ok(settings).build();
    }

    public ServiceResponse setSettings(int retentionPeriod, int numberOfEventsPerPage, boolean isSystemAdminAccessOnly, List<String> notifiedUsers, boolean writeToSyslog, String syslogHost, Integer syslogFacility, Integer syslogLevel, boolean writeToFile, String filePath) {
        User user = this.userUtils.getCurrentUser();
        String username = user == null ? null : user.getUsername();
        Settings settings = this.settingsService.getSettings();
        if (username == null || !this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            log.error("User %s is not authorized to edit settings.", user);
            return ServiceResponse.serverError().status(403).build();
        }
        log.debug("Set retention period to %d", retentionPeriod);
        settings.setRetentionPeriod(Duration.ofDays(retentionPeriod));
        settings.setNumberOfEventsPerPage(numberOfEventsPerPage);
        settings.setSystemAdminAccessOnly(isSystemAdminAccessOnly);
        settings.setNotifiedUsers(this.getUsers(notifiedUsers));
        settings.setWriteToSyslog(writeToSyslog);
        settings.setSyslogHost(syslogHost);
        settings.setSyslogFacility(syslogFacility != null ? syslogFacility : -1);
        settings.setSyslogLevel(syslogLevel != null ? syslogLevel : -1);
        settings.setWriteToFile(writeToFile);
        settings.setFilePath(filePath);
        List<String> errors = this.validate(settings);
        if (errors.isEmpty()) {
            this.settingsService.setSettings(settings);
        }
        return ServiceResponse.ok(errors).build();
    }

    private List<String> validate(Settings settings) {
        int syslogLevel;
        ArrayList<String> errors = new ArrayList<String>();
        if (settings.isWriteToFile() && !this.fileUtils.initFile(settings.getFilePath())) {
            errors.add("Invalid log file path.");
        }
        if ((syslogLevel = settings.getSyslogLevel()) == -1 || ((ImmutableCollection)((Object)PersistentSettingsServiceImpl.OLD_TO_NEW_SEVERITY_MAP.keySet())).contains(syslogLevel)) {
            errors.add("Severity and facility lists were updated after the latest plugin version installation. Please <a href=\"javascript:window.location.reload(true)\">reload the page</a> and try again.");
        }
        return errors;
    }

    private List<User> getUsers(List<String> usernames) {
        ArrayList<User> users = new ArrayList<User>();
        for (String username : usernames) {
            UserProfile user = this.userManager.getUserProfile(username);
            if (user == null) continue;
            users.add(new UserImpl(user.getUsername(), user.getFullName(), user.getEmail()));
        }
        return users;
    }
}

