/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.logwriters;

import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventCriteria;
import com.enhancera.auditor.common.database.DataLayer;
import com.enhancera.auditor.common.logwriters.AuditLogWriter;
import com.enhancera.auditor.common.settings.SettingsService;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;

public class DatabaseAuditLogWriter
implements AuditLogWriter {
    private static final FormattingLogger log = FormattingLogger.getLogger(DatabaseAuditLogWriter.class);
    private static final Duration CLEANUP_CHECK_PERIOD = Duration.ofHours(6L);
    private final DataLayer dataLayer;
    private final SettingsService settingsService;
    private Instant lastCleanupTime = LocalDate.parse("1970-01-01").atStartOfDay(ZoneOffset.UTC).toInstant();

    public DatabaseAuditLogWriter(DataLayer dataLayer, SettingsService settingsService) {
        this.dataLayer = dataLayer;
        this.settingsService = settingsService;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void write(Event event) {
        log.debug("Writing event %s to database", event.getSummary());
        this.dataLayer.writeEvent(event);
        Instant now = Instant.now();
        if (this.lastCleanupTime.isBefore(now.minus(CLEANUP_CHECK_PERIOD))) {
            this.lastCleanupTime = now;
            Duration retentionPeriod = this.settingsService.getSettings().getRetentionPeriod();
            if (retentionPeriod.compareTo(Duration.ZERO) > 0) {
                log.debug("Clear events older than %s", retentionPeriod);
                this.dataLayer.deleteEvents(EventCriteria.before(now.minus(retentionPeriod)));
            }
        }
    }

    @Override
    public void clear() {
        log.debug("Clearing the database", new Object[0]);
        this.dataLayer.deleteEvents(EventCriteria.ALL);
    }
}

