/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.servlet.javax;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.enhancera.auditor.common.EventTemplate;
import com.enhancera.auditor.common.RequestData;
import com.enhancera.auditor.common.RequestProcessor;
import com.enhancera.auditor.common.ResponseData;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.UserUtils;
import com.enhancera.servlet.javax.ChainDoFilterException;
import com.enhancera.servlet.javax.StatusExposingServletResponse;
import com.enhancera.servlet.javax.util.RequestUtils;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.time.Instant;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@AnonymousSiteAccess
public class WebEventsFilter
implements Filter {
    private static final FormattingLogger log = FormattingLogger.getLogger(WebEventsFilter.class);
    private FilterConfig config;
    private final UserUtils userUtils;
    private final RequestProcessor requestProcessor;

    public WebEventsFilter(UserUtils userUtils, RequestProcessor requestProcessor) {
        this.userUtils = userUtils;
        this.requestProcessor = requestProcessor;
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    public void destroy() {
        this.config = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            log.info("Either request or response are non-HTTP.Don't know how to deal with them, so just skipping.", new Object[0]);
            chain.doFilter(request, response);
            return;
        }
        try {
            EventTemplate eventTemplate;
            HttpServletRequest req = (HttpServletRequest)request;
            String url = req.getRequestURI();
            String ipAddress = RequestUtils.extractIpAddress(req);
            User author = this.userUtils.getCurrentUser();
            ListMultimap<String, String> requestParameters = RequestUtils.getParametersMultimap(req);
            ListMultimap<String, String> requestHeaders = RequestUtils.getHeadersMultimap(req);
            Instant time = Instant.now();
            String method = req.getMethod();
            RequestData requestData = new RequestData(author, ipAddress, time, method, url, requestParameters, requestHeaders);
            try {
                eventTemplate = this.requestProcessor.preprocess(requestData);
            }
            catch (Exception e) {
                log.error(e, "Error occurred preprocessing request data: " + requestData, new Object[0]);
                WebEventsFilter.doFilterInsideTryBlock(request, response, chain);
                return;
            }
            if (eventTemplate != null) {
                StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse((HttpServletResponse)response, this.requestProcessor.getErrorPatterns());
                WebEventsFilter.doFilterInsideTryBlock(request, (ServletResponse)wrappedResponse, chain);
                ResponseData responseData = wrappedResponse.getResponseData();
                log.debug("Auditor action: %s, responseData: %s", url, responseData);
                try {
                    this.requestProcessor.postprocess(eventTemplate, requestData, responseData);
                }
                catch (Exception e) {
                    log.error(e, "Error occurred postprocessing request data: " + requestData, new Object[0]);
                }
            } else {
                WebEventsFilter.doFilterInsideTryBlock(request, response, chain);
            }
        }
        catch (ChainDoFilterException e) {
            try {
                throw (Exception)e.getCause();
            }
            catch (IOException | RuntimeException | ServletException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Exception e) {
            log.error(e, "Error processing web request", new Object[0]);
            chain.doFilter(request, response);
        }
    }

    public static void doFilterInsideTryBlock(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws ChainDoFilterException {
        try {
            chain.doFilter(servletRequest, servletResponse);
        }
        catch (Exception e) {
            throw new ChainDoFilterException(e);
        }
    }
}

