/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.servlet.javax;

import com.enhancera.auditor.common.util.FormattingLogger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RestReadingServletRequest
extends HttpServletRequestWrapper {
    private static final FormattingLogger log = FormattingLogger.getLogger(RestReadingServletRequest.class);
    private final byte[] body;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RestReadingServletRequest(HttpServletRequest request) throws IOException {
        ByteArrayOutputStream baos;
        block10: {
            super(request);
            BufferedInputStream bis = null;
            baos = new ByteArrayOutputStream();
            try {
                ServletInputStream inputStream = request.getInputStream();
                if (inputStream != null) {
                    bis = new BufferedInputStream((InputStream)inputStream);
                    byte[] byteBuffer = new byte[1024];
                    int bytesRead = -1;
                    while ((bytesRead = bis.read(byteBuffer)) > 0) {
                        baos.write(byteBuffer, 0, bytesRead);
                    }
                }
                if (bis == null) break block10;
            }
            catch (IOException ex) {
                try {
                    log.error("Error reading request input stream: %s", ex.getMessage());
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (bis == null) throw throwable;
                    try {
                        bis.close();
                        baos.close();
                        throw throwable;
                    }
                    catch (IOException ex2) {
                        log.error("Error closing request input stream: %s", ex2.getMessage());
                        throw ex2;
                    }
                }
            }
            try {
                bis.close();
                baos.close();
            }
            catch (IOException ex) {
                log.error("Error closing request input stream: %s", ex.getMessage());
                throw ex;
            }
        }
        this.body = baos.toByteArray();
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getBody() {
        try {
            return new String(this.body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.body);
        }
    }
}

