/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.servlet.javax;

import com.enhancera.servlet.javax.ContentCapturingOutputStream;
import com.enhancera.servlet.javax.ContentCapturingPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class ContentCapturingServletResponse
extends HttpServletResponseWrapper {
    private Output usedOutput = null;
    private ContentCapturingOutputStream sos = null;
    private ContentCapturingPrintWriter pw = null;

    public ContentCapturingServletResponse(HttpServletResponse response) {
        super(response);
    }

    public abstract ContentCapturingOutputStream createStream() throws IOException;

    public abstract ContentCapturingPrintWriter createWriter() throws IOException;

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usedOutput != null && this.usedOutput != Output.STREAM) {
            return super.getOutputStream();
        }
        if (this.sos == null) {
            this.sos = this.createStream();
            this.usedOutput = Output.STREAM;
        }
        return this.sos;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usedOutput != null && this.usedOutput != Output.WRITER) {
            return super.getWriter();
        }
        if (this.pw == null) {
            this.pw = this.createWriter();
            this.usedOutput = Output.WRITER;
        }
        return this.pw;
    }

    public String getContent() {
        if (this.usedOutput != null) {
            switch (this.usedOutput) {
                case STREAM: {
                    return this.sos.getContent();
                }
                case WRITER: {
                    return this.pw.getContent();
                }
            }
        }
        return null;
    }

    public static enum Output {
        STREAM,
        WRITER;

    }
}

