/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.gson.Gson;
import java.util.List;

public class RateLimitingRequestsPerNodeByJsonTransformer
extends SingleArgumentTransformer {
    @Override
    public List<String> transform(String arg) {
        Gson gson = new Gson();
        RateLimit rateLimit = gson.fromJson(arg, RateLimit.class);
        String result = rateLimit.fillRate + " per " + rateLimit.intervalFrequency + " " + rateLimit.intervalTimeUnit.toLowerCase();
        return ConvertionUtils.values(result, rateLimit.capacity);
    }

    @Override
    public List<String> returnIfNull() {
        return ConvertionUtils.nullValues(2);
    }

    private static class RateLimit {
        private final int capacity;
        private final int fillRate;
        private final int intervalFrequency;
        private final String intervalTimeUnit;

        private RateLimit(int capacity, int fillRate, int intervalFrequency, String intervalTimeUnit) {
            this.capacity = capacity;
            this.fillRate = fillRate;
            this.intervalFrequency = intervalFrequency;
            this.intervalTimeUnit = intervalTimeUnit;
        }
    }
}

