/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.page.Pager;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UsersByGroupNameTransformer
extends SingleArgumentTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(UsersByGroupNameTransformer.class);
    private static final int USER_LIMIT = 100;
    private final GroupManager groupManager;

    public UsersByGroupNameTransformer(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    @Override
    public List<String> transform(String arg) {
        Pager users = null;
        try {
            Group group = this.groupManager.getGroup(arg);
            if (group != null) {
                users = this.groupManager.getMemberNames(group);
            }
        }
        catch (EntityException e) {
            log.error(e, "Error obtaining users by group name: " + arg, new Object[0]);
            return this.returnIfNull();
        }
        if (users == null) {
            return this.returnIfNull();
        }
        Iterator iterator = users.iterator();
        ArrayList<String> showedUsers = new ArrayList<String>();
        for (int i = 0; i < 100 && iterator.hasNext(); ++i) {
            showedUsers.add((String)iterator.next());
        }
        int usersLeft = this.count((Pager<String>)users) - showedUsers.size();
        if (usersLeft > 0) {
            showedUsers.add("and " + usersLeft + " more...");
        }
        return ConvertionUtils.values(showedUsers.isEmpty() ? "<none>" : Joiner.on(", ").join(showedUsers));
    }

    private int count(Pager<String> users) {
        while (!users.onLastPage()) {
            users.nextPage();
        }
        return users.getIndexOfFirstItemInCurrentPage() + users.getCurrentPage().size();
    }
}

