/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.util.List;

public abstract class DarkColorSchemeColorsBySpaceKeyTransformer
implements Transformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(DarkColorSchemeColorsBySpaceKeyTransformer.class);
    private static final String DARK_THEME_COLOR_SCHEME_PROPERTIES_SUFFIX = ".dark";
    private final ColourSchemeManager colourSchemeManager;

    public DarkColorSchemeColorsBySpaceKeyTransformer(ColourSchemeManager colourSchemeManager) {
        this.colourSchemeManager = colourSchemeManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        ColourScheme scheme = args.isEmpty() ? this.colourSchemeManager.getGlobalColourScheme() : this.colourSchemeManager.getSpaceColourScheme(args.get(0));
        List<String> colorSchemeProperties = this.getColorSchemeProperties();
        if (scheme == null) {
            log.error("Color scheme not found for space key: " + args.get(0), new Object[0]);
            return ConvertionUtils.nullValues(colorSchemeProperties.size());
        }
        return ConvertionUtils.values(colorSchemeProperties.stream().map(key -> scheme.get(key + DARK_THEME_COLOR_SCHEME_PROPERTIES_SUFFIX)).toArray());
    }

    public abstract List<String> getColorSchemeProperties();
}

