/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import java.util.List;

public class PrimarySpaceApplicationLinkTransformer
implements Transformer {
    private final EntityLinkService entityLinkService;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;

    public PrimarySpaceApplicationLinkTransformer(EntityLinkService entityLinkService, SpaceManager spaceManager, UserAccessor userAccessor) {
        this.entityLinkService = entityLinkService;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
    }

    @Override
    public List<String> transform(List<String> args) {
        if (args.get(0) == null) {
            return ConvertionUtils.nullValues(1);
        }
        ConfluenceUser user = this.userAccessor.getUserByName(args.get(1));
        AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        Space space = this.spaceManager.getSpace(args.get(0));
        if (space == null) {
            return ConvertionUtils.nullValues(1);
        }
        Iterable links = this.entityLinkService.getEntityLinks((Object)space);
        for (EntityLink link : links) {
            if (!link.isPrimary()) continue;
            return ConvertionUtils.values(link.getName());
        }
        return ConvertionUtils.nullValues(1);
    }
}

