/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.cache.ThreadLocalCache;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.setup.settings.beans.CaptchaSettings;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;

public class CaptchaExcludeSettingsTransformer
implements Transformer {
    private final SettingsManager settingsManager;

    public CaptchaExcludeSettingsTransformer(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        Preconditions.checkArgument(args.isEmpty());
        ThreadLocalCache.flush();
        CaptchaSettings settings = this.settingsManager.getGlobalSettings().getCaptchaSettings();
        String exclude = null;
        String groups = null;
        switch (settings.getExclude()) {
            case "none": {
                exclude = "No one (everyone will see captchas)";
                break;
            }
            case "registered": {
                exclude = "Signed in users";
                break;
            }
            case "groups": {
                exclude = "Members of the following groups";
                groups = Joiner.on(", ").join(settings.getCaptchaGroups());
                break;
            }
            default: {
                exclude = settings.getExclude();
            }
        }
        return ConvertionUtils.values(exclude, groups);
    }
}

