/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common;

import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.enhancera.auditor.common.BackupRestoringEventTracker;
import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.EventDetail;
import com.enhancera.auditor.common.EventTemplate;
import com.enhancera.auditor.common.RequestData;
import com.enhancera.auditor.common.RequestProcessor;
import com.enhancera.auditor.common.RequestType;
import com.enhancera.auditor.common.ResponseData;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.UserImpl;
import com.enhancera.auditor.common.conditions.Condition;
import com.enhancera.auditor.common.conditions.ConditionManager;
import com.enhancera.auditor.common.logwriters.AuditLogWriter;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.transformers.TransformerManager;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.enhancera.auditor.common.util.JsonProxy;
import com.enhancera.auditor.common.util.LicenseCheckResult;
import com.enhancera.auditor.common.util.LicenseChecker;
import com.enhancera.auditor.configuration.ArgumentConfig;
import com.enhancera.auditor.configuration.ConditionConfig;
import com.enhancera.auditor.configuration.ConfigurationService;
import com.enhancera.auditor.configuration.DetailConfig;
import com.enhancera.auditor.configuration.EventConfig;
import com.enhancera.auditor.configuration.ParameterConfig;
import com.enhancera.auditor.configuration.RootConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RequestProcessorImpl
implements RequestProcessor {
    private static final FormattingLogger log = FormattingLogger.getLogger(RequestProcessorImpl.class);
    private static final FormattingLogger requestLog = FormattingLogger.getLogger("requestlog");
    public static final User UNKNOWN_USER = new UserImpl("unknown");
    private static final long LICENSE_CHECK_REPORT_INTERVAL_MILLIS = 300000L;
    private long lastReportedTime = 0L;
    private final ConfigurationService configurationService;
    private final AuditLogWriter auditLogWriter;
    private final TransformerManager transformerManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final LicenseChecker licenseChecker;
    private final BackupRestoringEventTracker backupRestoringEventTracker;
    private final Executor asyncTaskExecutor;
    private final Executor syncTaskExecutor;
    private final TransactionTemplate transactionTemplate;
    private final ConditionManager conditionManager;

    public RequestProcessorImpl(ConfigurationService configurationService, AuditLogWriter auditLogWriter, TransformerManager transformerManager, PluginLicenseManager pluginLicenseManager, LicenseChecker licenseChecker, BackupRestoringEventTracker backupRestoringEventTracker, Executor asyncTaskExecutor, TransactionTemplate transactionTemplate, ConditionManager conditionManager) {
        this.configurationService = configurationService;
        this.auditLogWriter = auditLogWriter;
        this.transformerManager = transformerManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.licenseChecker = licenseChecker;
        this.backupRestoringEventTracker = backupRestoringEventTracker;
        this.asyncTaskExecutor = asyncTaskExecutor;
        this.syncTaskExecutor = new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
        this.transactionTemplate = transactionTemplate;
        this.conditionManager = conditionManager;
        this.auditLogWriter.initialize();
    }

    @Override
    public EventTemplate preprocess(RequestData requestData) {
        log.debug("Pre-processing request %s", requestData);
        LicenseCheckResult licenseCheckResult = this.licenseChecker.checkLicense((Option<PluginLicense>)this.pluginLicenseManager.getLicense());
        if (!licenseCheckResult.isOk()) {
            if (System.currentTimeMillis() - this.lastReportedTime > 300000L) {
                log.warn("Audit logging disabled due to the following reason: %s", licenseCheckResult.getMessage());
                this.lastReportedTime = System.currentTimeMillis();
            }
            return null;
        }
        EventConfig eventConfig = this.getEvent(requestData);
        if (eventConfig == null) {
            log.debug("No event detected.", new Object[0]);
            return null;
        }
        log.debug("Detected event: %s", eventConfig);
        Event event = this.createEvent(eventConfig, requestData);
        log.debug("Created event: %s", event);
        EventTemplate eventTemplate = new EventTemplate(eventConfig, event);
        if (eventConfig.getPhase() == EventConfig.Phase.BEFORE) {
            event = this.updateEvent(eventTemplate, requestData);
            this.write(new EventTemplate(eventConfig, event));
            return null;
        }
        return eventTemplate;
    }

    @Override
    public void postprocess(final EventTemplate eventTemplate, final RequestData requestData, final ResponseData responseData) {
        Executor executor;
        switch (eventTemplate.getEventConfig().getProcessing()) {
            case SYNC: {
                executor = this.syncTaskExecutor;
                break;
            }
            default: {
                executor = this.asyncTaskExecutor;
            }
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                log.debug("Processing request %s", requestData);
                requestLog.info("%s\n%s\n", requestData.getUrl(), requestData.getRequestParameters());
                boolean isError = false;
                if (responseData.isHttpError()) {
                    log.debug("HTTP error %d detected when processing request to URL %s", responseData.getHttpStatus(), requestData.getUrl());
                    isError = true;
                }
                if (responseData.isErrorDetectedInOutput()) {
                    log.debug("Host app validation error detected when processing request to URL %s", requestData.getUrl());
                    isError = true;
                }
                if (isError) {
                    Event event;
                    if (eventTemplate.getEventConfig().getErrorHandling() == EventConfig.ErrorHandling.LOG_IF_CHANGED && RequestProcessorImpl.this.hasChangedDetails(event = RequestProcessorImpl.this.updateEvent(eventTemplate, requestData))) {
                        RequestProcessorImpl.this.write(new EventTemplate(eventTemplate.getEventConfig(), event));
                    }
                    return;
                }
                Event event = RequestProcessorImpl.this.updateEvent(eventTemplate, requestData);
                if (RequestProcessorImpl.this.backupRestoringEventTracker.isBackupRestoringEvent(event)) {
                    RequestProcessorImpl.this.backupRestoringEventTracker.storeEvent(event);
                } else {
                    RequestProcessorImpl.this.write(new EventTemplate(eventTemplate.getEventConfig(), event));
                }
            }
        });
    }

    private void write(EventTemplate eventTemplate) {
        Condition condition = (Condition)this.conditionManager.getByName(eventTemplate.getEventConfig().getCondition().getConditionName());
        if (condition.check(eventTemplate.getEvent())) {
            this.write(eventTemplate.getEvent());
        }
    }

    private void write(Event event) {
        this.auditLogWriter.write(event);
    }

    @Override
    public void clearEventLog() {
        this.auditLogWriter.clear();
    }

    @Override
    public List<Pattern> getErrorPatterns() {
        RootConfig config = this.configurationService.getConfiguration();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String errorPattern : config.getErrorPatternList()) {
            patterns.add(Pattern.compile(errorPattern));
        }
        return patterns;
    }

    private boolean hasChangedDetails(Event event) {
        for (EventDetail detail : event.getDetails()) {
            if (!detail.isDiff()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    @VisibleForTesting
    EventConfig getEvent(RequestData requestData) {
        String method = requestData.getMethod();
        String url = requestData.getUrl();
        RequestType type = requestData.getType();
        ListMultimap<String, String> requestParameters = requestData.getRequestParameters();
        ListMultimap<String, String> requestHeaders = requestData.getRequestHeaders();
        JsonProxy jsonBody = requestData.getJsonBody();
        RootConfig config = this.configurationService.getConfiguration();
        for (EventConfig event : config.getEventList()) {
            if (!this.isConditionSatisfiedBy(event.getCondition(), method, url, type, requestParameters, requestHeaders, jsonBody)) continue;
            event = this.processDetailNames(event, requestData);
            log.debug("Detected event %s for %s %s %s %s", event, method, url, requestParameters, jsonBody);
            return event;
        }
        return null;
    }

    private EventConfig processDetailNames(EventConfig event, RequestData requestData) {
        EventConfig.Builder eventBuilder = EventConfig.newBuilder(event);
        for (int i = 0; i < eventBuilder.getDetailCount(); ++i) {
            DetailConfig detail = eventBuilder.getDetail(i);
            if (!detail.hasNameTransformerName()) continue;
            DetailConfig.Builder detailBuilder = DetailConfig.newBuilder(detail);
            Transformer nameTransformer = (Transformer)this.transformerManager.getByName(detail.getNameTransformerName());
            List<String> names = nameTransformer.transform(this.getArguments(requestData, event.getCondition(), detail.getArgumentList()));
            if (names.size() == 0 || names.contains(null)) {
                eventBuilder.removeDetail(i--);
                continue;
            }
            detailBuilder.addAllName(names);
            eventBuilder.setDetail(i, detailBuilder.build());
        }
        return eventBuilder.build();
    }

    @VisibleForTesting
    Event createEvent(EventConfig eventConfig, RequestData requestData) {
        ArrayList<EventDetail> eventDetails = new ArrayList<EventDetail>();
        for (DetailConfig detail : eventConfig.getDetailList()) {
            List<String> detailValues = this.getValues(detail, requestData, DetailConfig.Phase.BEFORE, eventConfig.getCondition());
            Preconditions.checkState(detailValues.size() == detail.getNameCount(), "%s != %s", detailValues.size(), detail.getNameCount());
            for (int i = 0; i < detailValues.size(); ++i) {
                eventDetails.add(new EventDetail(detail.getName(i), detailValues.get(i), null, detail.getPhase() == DetailConfig.Phase.BEFORE_AND_AFTER));
            }
        }
        User author = requestData.getAuthor() == null ? UNKNOWN_USER : requestData.getAuthor();
        return new Event(author.getUsername(), requestData.getIpAddress(), requestData.getTime(), eventConfig.getCategory(), eventConfig.getSummary(), this.getOnlyValue(eventConfig.getObject(), requestData, DetailConfig.Phase.BEFORE, eventConfig.getCondition()), eventDetails);
    }

    @VisibleForTesting
    Event updateEvent(final EventTemplate eventTemplate, final RequestData requestData) {
        return (Event)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Event>(){

            public Event doInTransaction() {
                Event event = eventTemplate.getEvent();
                EventConfig eventConfig = eventTemplate.getEventConfig();
                ArrayList<EventDetail> eventDetails = new ArrayList<EventDetail>();
                int eventDetailsProcessedCount = 0;
                for (int i = 0; i < eventConfig.getDetailCount(); ++i) {
                    DetailConfig detailConfig = eventConfig.getDetail(i);
                    List<String> newValues = RequestProcessorImpl.this.getValues(detailConfig, requestData, DetailConfig.Phase.AFTER, eventConfig.getCondition());
                    for (String newValue : newValues) {
                        EventDetail originalDetail = event.getDetails().get(eventDetailsProcessedCount++);
                        EventDetail updatedDetail = originalDetail.withNewValue(newValue);
                        if (updatedDetail == null) continue;
                        eventDetails.add(updatedDetail);
                    }
                }
                return event.withObject(RequestProcessorImpl.this.getOnlyValue(eventConfig.getObject(), requestData, DetailConfig.Phase.AFTER, eventConfig.getCondition())).withDetails(eventDetails);
            }
        });
    }

    private String getOnlyValue(DetailConfig detailConfig, RequestData requestData, DetailConfig.Phase phase, ConditionConfig condition) {
        return Iterables.getOnlyElement(this.getValues(detailConfig, requestData, phase, condition));
    }

    @VisibleForTesting
    List<String> getValues(DetailConfig detailConfig, RequestData requestData, DetailConfig.Phase phase, ConditionConfig condition) {
        if (Strings.isNullOrEmpty(detailConfig.getTransformerName()) && detailConfig.getArgumentCount() == 0) {
            return Collections.singletonList(null);
        }
        if (detailConfig.getPhase() != DetailConfig.Phase.BEFORE_AND_AFTER && detailConfig.getPhase() != phase) {
            return Collections.nCopies(Math.max(1, detailConfig.getNameCount()), null);
        }
        List<String> args = this.getArguments(requestData, condition, detailConfig.getArgumentList());
        return ((Transformer)this.transformerManager.getByName(detailConfig.getTransformerName())).transform(args);
    }

    private List<String> getArguments(RequestData requestData, ConditionConfig condition, List<ArgumentConfig> argumentConfigs) {
        ListMultimap<String, String> requestParams = requestData.getRequestParameters();
        JsonProxy jsonBody = requestData.getJsonBody();
        ArrayList<String> args = new ArrayList<String>();
        for (ArgumentConfig argument : argumentConfigs) {
            String argumentName = argument.getName();
            String value = null;
            if (argument.getSource() == ArgumentConfig.Source.CONST) {
                value = argumentName;
            } else if (argument.getSource() == ArgumentConfig.Source.URL) {
                int group = Integer.valueOf(argumentName);
                Pattern pattern = Pattern.compile(condition.getUrlPattern());
                Matcher matcher = pattern.matcher(requestData.getUrl());
                if (matcher.find()) {
                    value = matcher.group(group);
                }
            } else if (argument.getSource() == ArgumentConfig.Source.PARAMETER_NAME_AND_VALUE) {
                StringBuilder builder = new StringBuilder();
                if (requestParams != null) {
                    for (String parameter : requestParams.asMap().keySet()) {
                        if (!parameter.matches(argumentName)) continue;
                        builder.append(String.format("%s:%s; ", parameter, Joiner.on(",").join(requestParams.get((Object)parameter))));
                    }
                }
                if (jsonBody != null) {
                    for (String parameter : jsonBody.keys()) {
                        if (!parameter.matches(argumentName)) continue;
                        builder.append(String.format("%s:%s; ", parameter, jsonBody.get(parameter)));
                    }
                }
                value = builder.toString();
            } else if (argument.getSource() == ArgumentConfig.Source.BODY) {
                value = requestData.getBody().getBody();
            } else if (requestParams != null && requestParams.containsKey(argumentName)) {
                value = Joiner.on(", ").join(requestParams.get((Object)argumentName));
            } else if (jsonBody != null && jsonBody.get(argumentName) != null) {
                value = requestData.getJsonBody().get(argumentName);
            } else if (argument.getSource() == ArgumentConfig.Source.AUTHOR) {
                value = requestData.getAuthor().getUsername();
            }
            args.add(value);
        }
        return args;
    }

    boolean isConditionSatisfiedBy(ConditionConfig conditionConfig, String method, String url, ListMultimap<String, String> requestParameters, JsonProxy jsonBody) {
        return this.isConditionSatisfiedBy(conditionConfig, method, url, RequestType.WEB, requestParameters, null, jsonBody);
    }

    @VisibleForTesting
    boolean isConditionSatisfiedBy(ConditionConfig conditionConfig, String method, String url, RequestType type, ListMultimap<String, String> requestParameters, ListMultimap<String, String> requestHeaders, JsonProxy jsonBody) {
        if (!this.isUrlAccepted(conditionConfig, url, type)) {
            return false;
        }
        if (!this.isMethodAccepted(conditionConfig, method)) {
            log.debug("Condition not met. Method %s not accepted.", method);
            return false;
        }
        for (ParameterConfig parameter : conditionConfig.getParameterList()) {
            boolean jsonBodyOk;
            switch (parameter.getSource()) {
                case HEADER: {
                    return requestHeaders != null && this.isParameterSatisfiedBy(parameter, requestHeaders);
                }
            }
            boolean requestParamsOk = requestParameters != null && this.isParameterSatisfiedBy(parameter, requestParameters);
            boolean bl = jsonBodyOk = jsonBody != null && this.isParameterSatisfiedBy(parameter, jsonBody);
            if (requestParamsOk || jsonBodyOk) continue;
            log.debug("Condition not met. Parameter %s not satisfied.", parameter);
            return false;
        }
        log.debug("Condition met.", new Object[0]);
        return true;
    }

    boolean isConditionSatisfied(ConditionConfig conditionConfig, Event event) {
        Condition condition = (Condition)this.conditionManager.getByName(conditionConfig.getConditionName());
        return condition.check(event);
    }

    private boolean isMethodAccepted(ConditionConfig conditionConfig, String methodString) {
        try {
            ConditionConfig.Method method = ConditionConfig.Method.valueOf(methodString);
            return conditionConfig.getMethodList().contains(method);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private boolean isUrlAccepted(ConditionConfig conditionConfig, String url, RequestType type) {
        String urlPattern = conditionConfig.getUrlPattern();
        if (type == RequestType.WEB) {
            urlPattern = urlPattern.replaceAll("/", "/+");
        }
        Pattern pattern = Pattern.compile(urlPattern);
        Matcher matcher = pattern.matcher(url);
        return matcher.find();
    }

    private boolean isParameterSatisfiedBy(ParameterConfig parameterConfig, ListMultimap<String, String> requestParameters) {
        Pattern namePtrn = Pattern.compile(parameterConfig.getNamePattern());
        Pattern valuePtrn = Pattern.compile(parameterConfig.getValuePattern());
        for (Map.Entry entry : requestParameters.entries()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            Matcher nameMatcher = namePtrn.matcher(name);
            Matcher valueMatcher = valuePtrn.matcher(value);
            if (!nameMatcher.matches() || !valueMatcher.matches()) continue;
            return parameterConfig.getType() == ParameterConfig.Type.INCLUDE;
        }
        return parameterConfig.getType() == ParameterConfig.Type.EXCLUDE;
    }

    private boolean isParameterSatisfiedBy(ParameterConfig parameterConfig, JsonProxy jsonBody) {
        String value = jsonBody.get(parameterConfig.getNamePattern());
        if (value != null && value.matches(parameterConfig.getValuePattern())) {
            return parameterConfig.getType() == ParameterConfig.Type.INCLUDE;
        }
        return parameterConfig.getType() == ParameterConfig.Type.EXCLUDE;
    }
}

