/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.TrashManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TrashContentBySpaceKeyTransformer
extends SingleArgumentTransformer {
    private static final int LIST_ITEMS_THRESHOLD = 100;
    private final TrashManager trashManager;
    private final SpaceManager spaceManager;

    public TrashContentBySpaceKeyTransformer(TrashManager trashManager, SpaceManager spaceManager) {
        this.trashManager = trashManager;
        this.spaceManager = spaceManager;
    }

    @Override
    public List<String> transform(String arg) {
        String itemsString;
        String size;
        Space space = this.spaceManager.getSpace(arg);
        ArrayList items = new ArrayList(Lists.transform(this.trashManager.getTrashContents(space, 0, 101), ContentEntityObject::getTitle));
        if (items.size() > 100) {
            size = "100+";
            items.remove(items.size() - 1);
            itemsString = Joiner.on(", ").join(items);
            itemsString = itemsString + ", ...";
        } else {
            itemsString = Joiner.on(", ").join(items);
            size = String.valueOf(items.size());
        }
        return ConvertionUtils.values(size, itemsString);
    }

    @Override
    public List<String> returnIfNull() {
        return ConvertionUtils.nullValues(2);
    }
}

