/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.cache.ThreadLocalCache;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Locale;

public class AttachmentStorageTransformer
implements Transformer {
    private final SettingsManager settingsManager;
    private final I18nResolver i18nResolver;

    public AttachmentStorageTransformer(SettingsManager settingsManager, I18nResolver i18nResolver) {
        this.settingsManager = settingsManager;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public List<String> transform(List<String> args) {
        Preconditions.checkArgument(args.isEmpty());
        ThreadLocalCache.flush();
        Settings settings = this.settingsManager.getGlobalSettings();
        return ConvertionUtils.values(this.i18nResolver.getText(Locale.ENGLISH, settings.getAttachmentDataStore()));
    }
}

