/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.transformers;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.enhancera.auditor.common.transformers.SingleValueTransformer;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class UsersFullNameByKeyTransformer
extends SingleValueTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(UsersFullNameByKeyTransformer.class);
    private final UserManager userManager;

    public UsersFullNameByKeyTransformer(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public String transformSingle(List<String> args) {
        Preconditions.checkArgument(args.size() == 1);
        String[] userKeyStrings = args.get(0).split(", ?");
        ArrayList<String> fullNames = new ArrayList<String>();
        for (String userKeyString : userKeyStrings) {
            UserKey userKey = new UserKey(userKeyString);
            UserProfile profile = this.userManager.getUserProfile(userKey);
            if (profile == null) {
                log.debug("User profile not found for key %s.", userKeyString);
                fullNames.add(userKeyString);
                continue;
            }
            fullNames.add(profile.getFullName());
        }
        String fullNamesString = Joiner.on(", ").join(fullNames);
        log.debug("User full names for key %s is '%s'.", args.get(0), fullNamesString);
        return fullNamesString;
    }
}

