/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.servlet.javax.util;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.enhancera.auditor.common.settings.Settings;
import com.enhancera.auditor.common.settings.SettingsService;
import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserRedirect {
    private final LoginUriProvider loginUriProvider;
    private final UserManager userManager;
    private final SettingsService settingsService;

    public UserRedirect(LoginUriProvider loginUriProvider, UserManager userManager, SettingsService settingsService) {
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
        this.settingsService = settingsService;
    }

    public boolean redirectIfNotAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String username = this.userManager.getRemoteUser().getUsername();
        if (username == null) {
            this.redirectToLogin(request, response);
            return true;
        }
        Settings settings = this.settingsService.getSettings();
        if (!this.userManager.isAdmin(username) || settings.isSystemAdminAccessOnly() && !this.userManager.isSystemAdmin(username)) {
            response.sendError(403);
            return true;
        }
        return false;
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(UserRedirect.getUri(request)).toASCIIString());
    }

    private static URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

