/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookService;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Optional;

public class WebhookDetailsByIdTransformer
extends SingleArgumentTransformer {
    private final WebhookService webhookService;

    public WebhookDetailsByIdTransformer(WebhookService webhookService) {
        this.webhookService = webhookService;
    }

    @Override
    public List<String> transform(String arg) {
        Integer id = Ints.tryParse(arg);
        if (id == null) {
            return this.returnIfNull();
        }
        Optional webhookObject = this.webhookService.findById(id.intValue());
        if (!webhookObject.isPresent()) {
            return this.returnIfNull();
        }
        Webhook webhook = (Webhook)webhookObject.get();
        return ConvertionUtils.values(webhook.getName(), webhook.getUrl(), webhook.getEvents(), webhook.isActive());
    }

    @Override
    public List<String> returnIfNull() {
        return ConvertionUtils.nullValues(4);
    }
}

