/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.cache.ThreadLocalCache;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.setup.settings.beans.LoginManagerSettings;
import com.enhancera.auditor.common.transformers.Transformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.List;

public class GlobalSecuritySettingsTransformer
implements Transformer {
    private final SettingsManager settingsManager;

    public GlobalSecuritySettingsTransformer(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public List<String> transform(List<String> args) {
        Boolean enableCaptcha;
        Preconditions.checkArgument(args.isEmpty());
        ThreadLocalCache.flush();
        Settings settings = this.settingsManager.getGlobalSettings();
        LoginManagerSettings loginManagerSettings = settings.getLoginManagerSettings();
        try {
            LoginManagerSettings l = settings.getLoginManagerSettings();
            Field f = l.getClass().getDeclaredField("enableElevatedSecurityCheck");
            f.setAccessible(true);
            enableCaptcha = (Boolean)f.get(l);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            enableCaptcha = null;
        }
        return ConvertionUtils.values(settings.isExternalUserManagement(), settings.isAddWildcardsToUserAndGroupSearches(), settings.isNofollowExternalLinks(), settings.isAllowRemoteApiAnonymous(), settings.isEnableSpaceStyles(), settings.isShowSystemInfoIn500Page(), settings.getEmailAddressVisibility(), settings.getMaxRssItems(), settings.getRssTimeout(), settings.getPageTimeout(), enableCaptcha, loginManagerSettings.getLoginAttemptsThreshold(), settings.getWebSudoEnabled(), settings.getWebSudoTimeout(), settings.getAttachmentSecurityLevel(), settings.isXsrfAddComments(), settings.isAntiXssMode());
    }
}

