/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.common.notifications;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.enhancera.auditor.common.Event;
import com.enhancera.auditor.common.HostAppService;
import com.enhancera.auditor.common.User;
import com.enhancera.auditor.common.notifications.Notification;
import com.enhancera.auditor.common.util.DateFormatter;
import com.enhancera.auditor.common.util.FormattingLogger;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class Notifications {
    private static final FormattingLogger log = FormattingLogger.getLogger(Notifications.class);
    private static final int EVENT_SUMMARY_LIMIT = 20;
    private final HostAppService hostAppService;
    private final TemplateRenderer templateRenderer;
    private final ApplicationProperties applicationProperties;
    private final DateFormatter dateFormatter;

    public Notifications(HostAppService hostAppService, TemplateRenderer templateRenderer, ApplicationProperties applicationProperties, DateFormatter dateFormatter) {
        this.hostAppService = hostAppService;
        this.templateRenderer = templateRenderer;
        this.applicationProperties = applicationProperties;
        this.dateFormatter = dateFormatter;
    }

    public Notification getEventSummaryNotification(List<Event> events, Iterable<User> users) {
        int totalEventNumber = events.size();
        if (totalEventNumber > 20) {
            events = events.subList(0, 20);
        }
        ImmutableMap<String, DateFormatter> params = ImmutableMap.of("application", this.hostAppService.getApplicationName(), "baseUrl", this.applicationProperties.getBaseUrl(UrlMode.CANONICAL), "events", events, "totalEventNumber", totalEventNumber, "dateFormatter", this.dateFormatter);
        StringWriter writer = new StringWriter();
        try {
            this.templateRenderer.render(this.hostAppService.getEmailNotificationVelocityPath(), params, (Writer)writer);
        }
        catch (IOException e) {
            log.error(e, "Error creating event summary notification message", new Object[0]);
        }
        String message = writer.toString();
        return new Notification(message, "text/html", users);
    }
}

