/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.servlet.jakarta.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.enhancera.auditor.common.rest.ServiceResponse;
import com.enhancera.auditor.common.rest.UpgradeServiceExecutor;
import com.enhancera.servlet.jakarta.rest.JakartaResponseAdapter;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Optional;

@Path(value="/upgrade")
@AdminOnly
public class JakartaUpgradeService {
    private final UpgradeServiceExecutor executor;

    public JakartaUpgradeService(UpgradeServiceExecutor executor) {
        this.executor = executor;
    }

    @GET
    @Produces(value={"application/json"})
    public Response currentStatus() {
        Optional<ServiceResponse> response = this.executor.currentStatus();
        if (!response.isPresent()) {
            return Response.serverError().build();
        }
        return JakartaResponseAdapter.toJakarta(response.get());
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response removeErrors() {
        Optional<ServiceResponse> response = this.executor.removeErrors();
        if (!response.isPresent()) {
            return Response.serverError().build();
        }
        return JakartaResponseAdapter.toJakarta(response.get());
    }
}

