/*
 * Decompiled with CFR 0.152.
 */
package com.enhancera.auditor.confluence.transformers;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.enhancera.auditor.common.transformers.SingleArgumentTransformer;
import com.enhancera.auditor.common.util.ConvertionUtils;
import com.enhancera.auditor.common.util.FormattingLogger;
import java.util.List;

public class UserAdditionalDetailsByKeyTransformer
extends SingleArgumentTransformer {
    private static final FormattingLogger log = FormattingLogger.getLogger(UserAdditionalDetailsByKeyTransformer.class);
    private final UserDetailsManager userDetailsManager;
    private final PersonalInformationManager personalInformationManager;
    private final UserAccessor userAccessor;

    public UserAdditionalDetailsByKeyTransformer(UserDetailsManager userDetailsManager, PersonalInformationManager personalInformationManager, UserAccessor userAccessor) {
        this.userDetailsManager = userDetailsManager;
        this.personalInformationManager = personalInformationManager;
        this.userAccessor = userAccessor;
    }

    @Override
    public List<String> transform(String arg) {
        UserKey userKey = new UserKey(arg);
        ConfluenceUser user = this.userAccessor.getUserByKey(userKey);
        if (user == null) {
            log.debug("User profile not found for key %s.", arg);
            return this.returnIfNull();
        }
        return ConvertionUtils.values(this.userDetailsManager.getStringProperty((User)user, "phone"), this.userDetailsManager.getStringProperty((User)user, "im"), this.userDetailsManager.getStringProperty((User)user, "website"), this.userDetailsManager.getStringProperty((User)user, "position"), this.userDetailsManager.getStringProperty((User)user, "department"), this.userDetailsManager.getStringProperty((User)user, "location"), this.personalInformationManager.getOrCreatePersonalInformation((User)user).getBodyAsString());
    }

    @Override
    public List<String> returnIfNull() {
        return ConvertionUtils.nullValues(7);
    }
}

